package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.{
  LongOptional,
  BooleanOptional,
  IntegerOptional
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyDbClusterRequest(
    dbClusterIdentifier: String,
    newDBClusterIdentifier: scala.Option[String] = None,
    applyImmediately: scala.Option[Boolean] = None,
    backupRetentionPeriod: scala.Option[IntegerOptional] = None,
    dbClusterParameterGroupName: scala.Option[String] = None,
    vpcSecurityGroupIds: scala.Option[Iterable[String]] = None,
    port: scala.Option[IntegerOptional] = None,
    masterUserPassword: scala.Option[String] = None,
    optionGroupName: scala.Option[String] = None,
    preferredBackupWindow: scala.Option[String] = None,
    preferredMaintenanceWindow: scala.Option[String] = None,
    enableIAMDatabaseAuthentication: scala.Option[BooleanOptional] = None,
    backtrackWindow: scala.Option[LongOptional] = None,
    cloudwatchLogsExportConfiguration: scala.Option[
      zio.aws.rds.model.CloudwatchLogsExportConfiguration
    ] = None,
    engineVersion: scala.Option[String] = None,
    allowMajorVersionUpgrade: scala.Option[Boolean] = None,
    dbInstanceParameterGroupName: scala.Option[String] = None,
    domain: scala.Option[String] = None,
    domainIAMRoleName: scala.Option[String] = None,
    scalingConfiguration: scala.Option[zio.aws.rds.model.ScalingConfiguration] =
      None,
    deletionProtection: scala.Option[BooleanOptional] = None,
    enableHttpEndpoint: scala.Option[BooleanOptional] = None,
    copyTagsToSnapshot: scala.Option[BooleanOptional] = None,
    enableGlobalWriteForwarding: scala.Option[BooleanOptional] = None,
    dbClusterInstanceClass: scala.Option[String] = None,
    allocatedStorage: scala.Option[IntegerOptional] = None,
    storageType: scala.Option[String] = None,
    iops: scala.Option[IntegerOptional] = None,
    autoMinorVersionUpgrade: scala.Option[BooleanOptional] = None,
    monitoringInterval: scala.Option[IntegerOptional] = None,
    monitoringRoleArn: scala.Option[String] = None,
    enablePerformanceInsights: scala.Option[BooleanOptional] = None,
    performanceInsightsKMSKeyId: scala.Option[String] = None,
    performanceInsightsRetentionPeriod: scala.Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest = {
    import ModifyDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(
        newDBClusterIdentifier.map(value => value: java.lang.String)
      )(_.newDBClusterIdentifier)
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(
        backupRetentionPeriod.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.backupRetentionPeriod)
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.enableIAMDatabaseAuthentication)
      .optionallyWith(
        backtrackWindow.map(value => LongOptional.unwrap(value): java.lang.Long)
      )(_.backtrackWindow)
      .optionallyWith(
        cloudwatchLogsExportConfiguration.map(value => value.buildAwsValue())
      )(_.cloudwatchLogsExportConfiguration)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        allowMajorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.allowMajorVersionUpgrade)
      .optionallyWith(
        dbInstanceParameterGroupName.map(value => value: java.lang.String)
      )(_.dbInstanceParameterGroupName)
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(
        _.domainIAMRoleName
      )
      .optionallyWith(scalingConfiguration.map(value => value.buildAwsValue()))(
        _.scalingConfiguration
      )
      .optionallyWith(
        deletionProtection.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.deletionProtection)
      .optionallyWith(
        enableHttpEndpoint.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.enableHttpEndpoint)
      .optionallyWith(
        copyTagsToSnapshot.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.copyTagsToSnapshot)
      .optionallyWith(
        enableGlobalWriteForwarding.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.enableGlobalWriteForwarding)
      .optionallyWith(
        dbClusterInstanceClass.map(value => value: java.lang.String)
      )(_.dbClusterInstanceClass)
      .optionallyWith(
        allocatedStorage.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.allocatedStorage)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(
        iops.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.iops)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        monitoringInterval.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.monitoringInterval)
      .optionallyWith(monitoringRoleArn.map(value => value: java.lang.String))(
        _.monitoringRoleArn
      )
      .optionallyWith(
        enablePerformanceInsights.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.enablePerformanceInsights)
      .optionallyWith(
        performanceInsightsKMSKeyId.map(value => value: java.lang.String)
      )(_.performanceInsightsKMSKeyId)
      .optionallyWith(
        performanceInsightsRetentionPeriod.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.performanceInsightsRetentionPeriod)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyDbClusterRequest.ReadOnly =
    zio.aws.rds.model.ModifyDbClusterRequest.wrap(buildAwsValue())
}
object ModifyDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbClusterRequest =
      zio.aws.rds.model.ModifyDbClusterRequest(
        dbClusterIdentifier,
        newDBClusterIdentifier.map(value => value),
        applyImmediately.map(value => value),
        backupRetentionPeriod.map(value => value),
        dbClusterParameterGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        port.map(value => value),
        masterUserPassword.map(value => value),
        optionGroupName.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        backtrackWindow.map(value => value),
        cloudwatchLogsExportConfiguration.map(value => value.asEditable),
        engineVersion.map(value => value),
        allowMajorVersionUpgrade.map(value => value),
        dbInstanceParameterGroupName.map(value => value),
        domain.map(value => value),
        domainIAMRoleName.map(value => value),
        scalingConfiguration.map(value => value.asEditable),
        deletionProtection.map(value => value),
        enableHttpEndpoint.map(value => value),
        copyTagsToSnapshot.map(value => value),
        enableGlobalWriteForwarding.map(value => value),
        dbClusterInstanceClass.map(value => value),
        allocatedStorage.map(value => value),
        storageType.map(value => value),
        iops.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        monitoringInterval.map(value => value),
        monitoringRoleArn.map(value => value),
        enablePerformanceInsights.map(value => value),
        performanceInsightsKMSKeyId.map(value => value),
        performanceInsightsRetentionPeriod.map(value => value)
      )
    def dbClusterIdentifier: String
    def newDBClusterIdentifier: scala.Option[String]
    def applyImmediately: scala.Option[Boolean]
    def backupRetentionPeriod: scala.Option[IntegerOptional]
    def dbClusterParameterGroupName: scala.Option[String]
    def vpcSecurityGroupIds: scala.Option[List[String]]
    def port: scala.Option[IntegerOptional]
    def masterUserPassword: scala.Option[String]
    def optionGroupName: scala.Option[String]
    def preferredBackupWindow: scala.Option[String]
    def preferredMaintenanceWindow: scala.Option[String]
    def enableIAMDatabaseAuthentication: scala.Option[BooleanOptional]
    def backtrackWindow: scala.Option[LongOptional]
    def cloudwatchLogsExportConfiguration: scala.Option[
      zio.aws.rds.model.CloudwatchLogsExportConfiguration.ReadOnly
    ]
    def engineVersion: scala.Option[String]
    def allowMajorVersionUpgrade: scala.Option[Boolean]
    def dbInstanceParameterGroupName: scala.Option[String]
    def domain: scala.Option[String]
    def domainIAMRoleName: scala.Option[String]
    def scalingConfiguration
        : scala.Option[zio.aws.rds.model.ScalingConfiguration.ReadOnly]
    def deletionProtection: scala.Option[BooleanOptional]
    def enableHttpEndpoint: scala.Option[BooleanOptional]
    def copyTagsToSnapshot: scala.Option[BooleanOptional]
    def enableGlobalWriteForwarding: scala.Option[BooleanOptional]
    def dbClusterInstanceClass: scala.Option[String]
    def allocatedStorage: scala.Option[IntegerOptional]
    def storageType: scala.Option[String]
    def iops: scala.Option[IntegerOptional]
    def autoMinorVersionUpgrade: scala.Option[BooleanOptional]
    def monitoringInterval: scala.Option[IntegerOptional]
    def monitoringRoleArn: scala.Option[String]
    def enablePerformanceInsights: scala.Option[BooleanOptional]
    def performanceInsightsKMSKeyId: scala.Option[String]
    def performanceInsightsRetentionPeriod: scala.Option[IntegerOptional]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getNewDBClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("newDBClusterIdentifier", newDBClusterIdentifier)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getBacktrackWindow: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("backtrackWindow", backtrackWindow)
    def getCloudwatchLogsExportConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.CloudwatchLogsExportConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudwatchLogsExportConfiguration",
      cloudwatchLogsExportConfiguration
    )
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAllowMajorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("allowMajorVersionUpgrade", allowMajorVersionUpgrade)
    def getDbInstanceParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbInstanceParameterGroupName",
        dbInstanceParameterGroupName
      )
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getDomainIAMRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleName)
    def getScalingConfiguration
        : ZIO[Any, AwsError, zio.aws.rds.model.ScalingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("scalingConfiguration", scalingConfiguration)
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getEnableHttpEndpoint: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enableHttpEndpoint", enableHttpEndpoint)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getEnableGlobalWriteForwarding: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enableGlobalWriteForwarding",
        enableGlobalWriteForwarding
      )
    def getDbClusterInstanceClass: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbClusterInstanceClass", dbClusterInstanceClass)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getMonitoringInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("monitoringInterval", monitoringInterval)
    def getMonitoringRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArn)
    def getEnablePerformanceInsights: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enablePerformanceInsights",
        enablePerformanceInsights
      )
    def getPerformanceInsightsKMSKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "performanceInsightsKMSKeyId",
        performanceInsightsKMSKeyId
      )
    def getPerformanceInsightsRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "performanceInsightsRetentionPeriod",
      performanceInsightsRetentionPeriod
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest
  ) extends zio.aws.rds.model.ModifyDbClusterRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val newDBClusterIdentifier: scala.Option[String] =
      scala.Option(impl.newDBClusterIdentifier()).map(value => value: String)
    override val applyImmediately: scala.Option[Boolean] =
      scala.Option(impl.applyImmediately()).map(value => value: Boolean)
    override val backupRetentionPeriod: scala.Option[IntegerOptional] = scala
      .Option(impl.backupRetentionPeriod())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val dbClusterParameterGroupName: scala.Option[String] = scala
      .Option(impl.dbClusterParameterGroupName())
      .map(value => value: String)
    override val vpcSecurityGroupIds: scala.Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val port: scala.Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val masterUserPassword: scala.Option[String] =
      scala.Option(impl.masterUserPassword()).map(value => value: String)
    override val optionGroupName: scala.Option[String] =
      scala.Option(impl.optionGroupName()).map(value => value: String)
    override val preferredBackupWindow: scala.Option[String] =
      scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override val preferredMaintenanceWindow: scala.Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val enableIAMDatabaseAuthentication
        : scala.Option[BooleanOptional] = scala
      .Option(impl.enableIAMDatabaseAuthentication())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val backtrackWindow: scala.Option[LongOptional] = scala
      .Option(impl.backtrackWindow())
      .map(value => zio.aws.rds.model.primitives.LongOptional(value))
    override val cloudwatchLogsExportConfiguration: scala.Option[
      zio.aws.rds.model.CloudwatchLogsExportConfiguration.ReadOnly
    ] = scala
      .Option(impl.cloudwatchLogsExportConfiguration())
      .map(value =>
        zio.aws.rds.model.CloudwatchLogsExportConfiguration.wrap(value)
      )
    override val engineVersion: scala.Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val allowMajorVersionUpgrade: scala.Option[Boolean] =
      scala.Option(impl.allowMajorVersionUpgrade()).map(value => value: Boolean)
    override val dbInstanceParameterGroupName: scala.Option[String] = scala
      .Option(impl.dbInstanceParameterGroupName())
      .map(value => value: String)
    override val domain: scala.Option[String] =
      scala.Option(impl.domain()).map(value => value: String)
    override val domainIAMRoleName: scala.Option[String] =
      scala.Option(impl.domainIAMRoleName()).map(value => value: String)
    override val scalingConfiguration
        : scala.Option[zio.aws.rds.model.ScalingConfiguration.ReadOnly] = scala
      .Option(impl.scalingConfiguration())
      .map(value => zio.aws.rds.model.ScalingConfiguration.wrap(value))
    override val deletionProtection: scala.Option[BooleanOptional] = scala
      .Option(impl.deletionProtection())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val enableHttpEndpoint: scala.Option[BooleanOptional] = scala
      .Option(impl.enableHttpEndpoint())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val copyTagsToSnapshot: scala.Option[BooleanOptional] = scala
      .Option(impl.copyTagsToSnapshot())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val enableGlobalWriteForwarding: scala.Option[BooleanOptional] =
      scala
        .Option(impl.enableGlobalWriteForwarding())
        .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val dbClusterInstanceClass: scala.Option[String] =
      scala.Option(impl.dbClusterInstanceClass()).map(value => value: String)
    override val allocatedStorage: scala.Option[IntegerOptional] = scala
      .Option(impl.allocatedStorage())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val storageType: scala.Option[String] =
      scala.Option(impl.storageType()).map(value => value: String)
    override val iops: scala.Option[IntegerOptional] = scala
      .Option(impl.iops())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val autoMinorVersionUpgrade: scala.Option[BooleanOptional] = scala
      .Option(impl.autoMinorVersionUpgrade())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val monitoringInterval: scala.Option[IntegerOptional] = scala
      .Option(impl.monitoringInterval())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val monitoringRoleArn: scala.Option[String] =
      scala.Option(impl.monitoringRoleArn()).map(value => value: String)
    override val enablePerformanceInsights: scala.Option[BooleanOptional] =
      scala
        .Option(impl.enablePerformanceInsights())
        .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val performanceInsightsKMSKeyId: scala.Option[String] = scala
      .Option(impl.performanceInsightsKMSKeyId())
      .map(value => value: String)
    override val performanceInsightsRetentionPeriod
        : scala.Option[IntegerOptional] = scala
      .Option(impl.performanceInsightsRetentionPeriod())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest
  ): zio.aws.rds.model.ModifyDbClusterRequest.ReadOnly = new Wrapper(impl)
}
