package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyDbClusterEndpointRequest(
    dbClusterEndpointIdentifier: String,
    endpointType: scala.Option[String] = None,
    staticMembers: scala.Option[Iterable[String]] = None,
    excludedMembers: scala.Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointRequest = {
    import ModifyDbClusterEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointRequest
      .builder()
      .dbClusterEndpointIdentifier(
        dbClusterEndpointIdentifier: java.lang.String
      )
      .optionallyWith(endpointType.map(value => value: java.lang.String))(
        _.endpointType
      )
      .optionallyWith(
        staticMembers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.staticMembers)
      .optionallyWith(
        excludedMembers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.excludedMembers)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyDbClusterEndpointRequest.ReadOnly =
    zio.aws.rds.model.ModifyDbClusterEndpointRequest.wrap(buildAwsValue())
}
object ModifyDbClusterEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbClusterEndpointRequest =
      zio.aws.rds.model.ModifyDbClusterEndpointRequest(
        dbClusterEndpointIdentifier,
        endpointType.map(value => value),
        staticMembers.map(value => value),
        excludedMembers.map(value => value)
      )
    def dbClusterEndpointIdentifier: String
    def endpointType: scala.Option[String]
    def staticMembers: scala.Option[List[String]]
    def excludedMembers: scala.Option[List[String]]
    def getDbClusterEndpointIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterEndpointIdentifier)
    def getEndpointType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getStaticMembers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("staticMembers", staticMembers)
    def getExcludedMembers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("excludedMembers", excludedMembers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointRequest
  ) extends zio.aws.rds.model.ModifyDbClusterEndpointRequest.ReadOnly {
    override val dbClusterEndpointIdentifier: String =
      impl.dbClusterEndpointIdentifier(): String
    override val endpointType: scala.Option[String] =
      scala.Option(impl.endpointType()).map(value => value: String)
    override val staticMembers: scala.Option[List[String]] = scala
      .Option(impl.staticMembers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val excludedMembers: scala.Option[List[String]] = scala
      .Option(impl.excludedMembers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointRequest
  ): zio.aws.rds.model.ModifyDbClusterEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
