package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GlobalClusterMember(
    dbClusterArn: scala.Option[String] = None,
    readers: scala.Option[Iterable[String]] = None,
    isWriter: scala.Option[Boolean] = None,
    globalWriteForwardingStatus: scala.Option[
      zio.aws.rds.model.WriteForwardingStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.GlobalClusterMember = {
    import GlobalClusterMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.GlobalClusterMember
      .builder()
      .optionallyWith(dbClusterArn.map(value => value: java.lang.String))(
        _.dbClusterArn
      )
      .optionallyWith(
        readers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.readers)
      .optionallyWith(isWriter.map(value => value: java.lang.Boolean))(
        _.isWriter
      )
      .optionallyWith(globalWriteForwardingStatus.map(value => value.unwrap))(
        _.globalWriteForwardingStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.GlobalClusterMember.ReadOnly =
    zio.aws.rds.model.GlobalClusterMember.wrap(buildAwsValue())
}
object GlobalClusterMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.GlobalClusterMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.GlobalClusterMember =
      zio.aws.rds.model.GlobalClusterMember(
        dbClusterArn.map(value => value),
        readers.map(value => value),
        isWriter.map(value => value),
        globalWriteForwardingStatus.map(value => value)
      )
    def dbClusterArn: scala.Option[String]
    def readers: scala.Option[List[String]]
    def isWriter: scala.Option[Boolean]
    def globalWriteForwardingStatus
        : scala.Option[zio.aws.rds.model.WriteForwardingStatus]
    def getDbClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterArn", dbClusterArn)
    def getReaders: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("readers", readers)
    def getIsWriter: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isWriter", isWriter)
    def getGlobalWriteForwardingStatus
        : ZIO[Any, AwsError, zio.aws.rds.model.WriteForwardingStatus] =
      AwsError.unwrapOptionField(
        "globalWriteForwardingStatus",
        globalWriteForwardingStatus
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.GlobalClusterMember
  ) extends zio.aws.rds.model.GlobalClusterMember.ReadOnly {
    override val dbClusterArn: scala.Option[String] =
      scala.Option(impl.dbClusterArn()).map(value => value: String)
    override val readers: scala.Option[List[String]] = scala
      .Option(impl.readers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val isWriter: scala.Option[Boolean] =
      scala.Option(impl.isWriter()).map(value => value: Boolean)
    override val globalWriteForwardingStatus
        : scala.Option[zio.aws.rds.model.WriteForwardingStatus] = scala
      .Option(impl.globalWriteForwardingStatus())
      .map(value => zio.aws.rds.model.WriteForwardingStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.GlobalClusterMember
  ): zio.aws.rds.model.GlobalClusterMember.ReadOnly = new Wrapper(impl)
}
