package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DoubleRange(
    from: scala.Option[Double] = None,
    to: scala.Option[Double] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.DoubleRange = {
    import DoubleRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DoubleRange
      .builder()
      .optionallyWith(from.map(value => value: java.lang.Double))(_.from)
      .optionallyWith(to.map(value => value: java.lang.Double))(_.to)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DoubleRange.ReadOnly =
    zio.aws.rds.model.DoubleRange.wrap(buildAwsValue())
}
object DoubleRange {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.DoubleRange] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DoubleRange = zio.aws.rds.model
      .DoubleRange(from.map(value => value), to.map(value => value))
    def from: scala.Option[Double]
    def to: scala.Option[Double]
    def getFrom: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("from", from)
    def getTo: ZIO[Any, AwsError, Double] = AwsError.unwrapOptionField("to", to)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DoubleRange
  ) extends zio.aws.rds.model.DoubleRange.ReadOnly {
    override val from: scala.Option[Double] =
      scala.Option(impl.from()).map(value => value: Double)
    override val to: scala.Option[Double] =
      scala.Option(impl.to()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DoubleRange
  ): zio.aws.rds.model.DoubleRange.ReadOnly = new Wrapper(impl)
}
