package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.{IntegerOptional, BooleanOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeReservedDbInstancesOfferingsRequest(
    reservedDBInstancesOfferingId: scala.Option[String] = None,
    dbInstanceClass: scala.Option[String] = None,
    duration: scala.Option[String] = None,
    productDescription: scala.Option[String] = None,
    offeringType: scala.Option[String] = None,
    multiAZ: scala.Option[BooleanOptional] = None,
    filters: scala.Option[Iterable[zio.aws.rds.model.Filter]] = None,
    maxRecords: scala.Option[IntegerOptional] = None,
    marker: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest = {
    import DescribeReservedDbInstancesOfferingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest
      .builder()
      .optionallyWith(
        reservedDBInstancesOfferingId.map(value => value: java.lang.String)
      )(_.reservedDBInstancesOfferingId)
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(duration.map(value => value: java.lang.String))(
        _.duration
      )
      .optionallyWith(productDescription.map(value => value: java.lang.String))(
        _.productDescription
      )
      .optionallyWith(offeringType.map(value => value: java.lang.String))(
        _.offeringType
      )
      .optionallyWith(
        multiAZ.map(value => BooleanOptional.unwrap(value): java.lang.Boolean)
      )(_.multiAZ)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeReservedDbInstancesOfferingsRequest.ReadOnly =
    zio.aws.rds.model.DescribeReservedDbInstancesOfferingsRequest
      .wrap(buildAwsValue())
}
object DescribeReservedDbInstancesOfferingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rds.model.DescribeReservedDbInstancesOfferingsRequest =
      zio.aws.rds.model.DescribeReservedDbInstancesOfferingsRequest(
        reservedDBInstancesOfferingId.map(value => value),
        dbInstanceClass.map(value => value),
        duration.map(value => value),
        productDescription.map(value => value),
        offeringType.map(value => value),
        multiAZ.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def reservedDBInstancesOfferingId: scala.Option[String]
    def dbInstanceClass: scala.Option[String]
    def duration: scala.Option[String]
    def productDescription: scala.Option[String]
    def offeringType: scala.Option[String]
    def multiAZ: scala.Option[BooleanOptional]
    def filters: scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]]
    def maxRecords: scala.Option[IntegerOptional]
    def marker: scala.Option[String]
    def getReservedDBInstancesOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedDBInstancesOfferingId",
        reservedDBInstancesOfferingId
      )
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getDuration: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("duration", duration)
    def getProductDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getOfferingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest
  ) extends zio.aws.rds.model.DescribeReservedDbInstancesOfferingsRequest.ReadOnly {
    override val reservedDBInstancesOfferingId: scala.Option[String] = scala
      .Option(impl.reservedDBInstancesOfferingId())
      .map(value => value: String)
    override val dbInstanceClass: scala.Option[String] =
      scala.Option(impl.dbInstanceClass()).map(value => value: String)
    override val duration: scala.Option[String] =
      scala.Option(impl.duration()).map(value => value: String)
    override val productDescription: scala.Option[String] =
      scala.Option(impl.productDescription()).map(value => value: String)
    override val offeringType: scala.Option[String] =
      scala.Option(impl.offeringType()).map(value => value: String)
    override val multiAZ: scala.Option[BooleanOptional] = scala
      .Option(impl.multiAZ())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val filters
        : scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Filter.wrap(item)
        }.toList
      )
    override val maxRecords: scala.Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest
  ): zio.aws.rds.model.DescribeReservedDbInstancesOfferingsRequest.ReadOnly =
    new Wrapper(impl)
}
