package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeEventsResponse(
    marker: scala.Option[String] = None,
    events: scala.Option[Iterable[zio.aws.rds.model.Event]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeEventsResponse = {
    import DescribeEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeEventsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeEventsResponse.ReadOnly =
    zio.aws.rds.model.DescribeEventsResponse.wrap(buildAwsValue())
}
object DescribeEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeEventsResponse =
      zio.aws.rds.model.DescribeEventsResponse(
        marker.map(value => value),
        events.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: scala.Option[String]
    def events: scala.Option[List[zio.aws.rds.model.Event.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getEvents: ZIO[Any, AwsError, List[zio.aws.rds.model.Event.ReadOnly]] =
      AwsError.unwrapOptionField("events", events)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeEventsResponse
  ) extends zio.aws.rds.model.DescribeEventsResponse.ReadOnly {
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val events: scala.Option[List[zio.aws.rds.model.Event.ReadOnly]] =
      scala
        .Option(impl.events())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Event.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeEventsResponse
  ): zio.aws.rds.model.DescribeEventsResponse.ReadOnly = new Wrapper(impl)
}
