package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDbProxyTargetsResponse(
    targets: scala.Option[Iterable[zio.aws.rds.model.DBProxyTarget]] = None,
    marker: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse = {
    import DescribeDbProxyTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse
      .builder()
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbProxyTargetsResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbProxyTargetsResponse.wrap(buildAwsValue())
}
object DescribeDbProxyTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbProxyTargetsResponse =
      zio.aws.rds.model.DescribeDbProxyTargetsResponse(
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def targets: scala.Option[List[zio.aws.rds.model.DBProxyTarget.ReadOnly]]
    def marker: scala.Option[String]
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.rds.model.DBProxyTarget.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse
  ) extends zio.aws.rds.model.DescribeDbProxyTargetsResponse.ReadOnly {
    override val targets
        : scala.Option[List[zio.aws.rds.model.DBProxyTarget.ReadOnly]] = scala
      .Option(impl.targets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBProxyTarget.wrap(item)
        }.toList
      )
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse
  ): zio.aws.rds.model.DescribeDbProxyTargetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
