package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.MaxRecords
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDbProxyTargetsRequest(
    dbProxyName: String,
    targetGroupName: scala.Option[String] = None,
    filters: scala.Option[Iterable[zio.aws.rds.model.Filter]] = None,
    marker: scala.Option[String] = None,
    maxRecords: scala.Option[MaxRecords] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest = {
    import DescribeDbProxyTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest
      .builder()
      .dbProxyName(dbProxyName: java.lang.String)
      .optionallyWith(targetGroupName.map(value => value: java.lang.String))(
        _.targetGroupName
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxRecords.map(value => MaxRecords.unwrap(value): Integer)
      )(_.maxRecords)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbProxyTargetsRequest.ReadOnly =
    zio.aws.rds.model.DescribeDbProxyTargetsRequest.wrap(buildAwsValue())
}
object DescribeDbProxyTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbProxyTargetsRequest =
      zio.aws.rds.model.DescribeDbProxyTargetsRequest(
        dbProxyName,
        targetGroupName.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value),
        maxRecords.map(value => value)
      )
    def dbProxyName: String
    def targetGroupName: scala.Option[String]
    def filters: scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]]
    def marker: scala.Option[String]
    def maxRecords: scala.Option[MaxRecords]
    def getDbProxyName: ZIO[Any, Nothing, String] = ZIO.succeed(dbProxyName)
    def getTargetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetGroupName", targetGroupName)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxRecords: ZIO[Any, AwsError, MaxRecords] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest
  ) extends zio.aws.rds.model.DescribeDbProxyTargetsRequest.ReadOnly {
    override val dbProxyName: String = impl.dbProxyName(): String
    override val targetGroupName: scala.Option[String] =
      scala.Option(impl.targetGroupName()).map(value => value: String)
    override val filters
        : scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Filter.wrap(item)
        }.toList
      )
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxRecords: scala.Option[MaxRecords] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.rds.model.primitives.MaxRecords(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest
  ): zio.aws.rds.model.DescribeDbProxyTargetsRequest.ReadOnly = new Wrapper(
    impl
  )
}
