package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDbProxyTargetGroupsResponse(
    targetGroups: scala.Option[Iterable[zio.aws.rds.model.DBProxyTargetGroup]] =
      None,
    marker: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse = {
    import DescribeDbProxyTargetGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse
      .builder()
      .optionallyWith(
        targetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetGroups)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeDbProxyTargetGroupsResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbProxyTargetGroupsResponse.wrap(buildAwsValue())
}
object DescribeDbProxyTargetGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbProxyTargetGroupsResponse =
      zio.aws.rds.model.DescribeDbProxyTargetGroupsResponse(
        targetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def targetGroups
        : scala.Option[List[zio.aws.rds.model.DBProxyTargetGroup.ReadOnly]]
    def marker: scala.Option[String]
    def getTargetGroups: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBProxyTargetGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("targetGroups", targetGroups)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse
  ) extends zio.aws.rds.model.DescribeDbProxyTargetGroupsResponse.ReadOnly {
    override val targetGroups
        : scala.Option[List[zio.aws.rds.model.DBProxyTargetGroup.ReadOnly]] =
      scala
        .Option(impl.targetGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBProxyTargetGroup.wrap(item)
          }.toList
        )
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse
  ): zio.aws.rds.model.DescribeDbProxyTargetGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
