package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDbParametersResponse(
    parameters: scala.Option[Iterable[zio.aws.rds.model.Parameter]] = None,
    marker: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse = {
    import DescribeDbParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse
      .builder()
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbParametersResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbParametersResponse.wrap(buildAwsValue())
}
object DescribeDbParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbParametersResponse =
      zio.aws.rds.model.DescribeDbParametersResponse(
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def parameters: scala.Option[List[zio.aws.rds.model.Parameter.ReadOnly]]
    def marker: scala.Option[String]
    def getParameters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse
  ) extends zio.aws.rds.model.DescribeDbParametersResponse.ReadOnly {
    override val parameters
        : scala.Option[List[zio.aws.rds.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Parameter.wrap(item)
        }.toList
      )
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse
  ): zio.aws.rds.model.DescribeDbParametersResponse.ReadOnly = new Wrapper(impl)
}
