package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeCertificatesResponse(
    certificates: scala.Option[Iterable[zio.aws.rds.model.Certificate]] = None,
    marker: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse = {
    import DescribeCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse
      .builder()
      .optionallyWith(
        certificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificates)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeCertificatesResponse.ReadOnly =
    zio.aws.rds.model.DescribeCertificatesResponse.wrap(buildAwsValue())
}
object DescribeCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeCertificatesResponse =
      zio.aws.rds.model.DescribeCertificatesResponse(
        certificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def certificates: scala.Option[List[zio.aws.rds.model.Certificate.ReadOnly]]
    def marker: scala.Option[String]
    def getCertificates
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Certificate.ReadOnly]] =
      AwsError.unwrapOptionField("certificates", certificates)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse
  ) extends zio.aws.rds.model.DescribeCertificatesResponse.ReadOnly {
    override val certificates
        : scala.Option[List[zio.aws.rds.model.Certificate.ReadOnly]] = scala
      .Option(impl.certificates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Certificate.wrap(item)
        }.toList
      )
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse
  ): zio.aws.rds.model.DescribeCertificatesResponse.ReadOnly = new Wrapper(impl)
}
