package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteDbClusterRequest(
    dbClusterIdentifier: String,
    skipFinalSnapshot: scala.Option[Boolean] = None,
    finalDBSnapshotIdentifier: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbClusterRequest = {
    import DeleteDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbClusterRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(skipFinalSnapshot.map(value => value: java.lang.Boolean))(
        _.skipFinalSnapshot
      )
      .optionallyWith(
        finalDBSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.finalDBSnapshotIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteDbClusterRequest.ReadOnly =
    zio.aws.rds.model.DeleteDbClusterRequest.wrap(buildAwsValue())
}
object DeleteDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbClusterRequest =
      zio.aws.rds.model.DeleteDbClusterRequest(
        dbClusterIdentifier,
        skipFinalSnapshot.map(value => value),
        finalDBSnapshotIdentifier.map(value => value)
      )
    def dbClusterIdentifier: String
    def skipFinalSnapshot: scala.Option[Boolean]
    def finalDBSnapshotIdentifier: scala.Option[String]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getSkipFinalSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("skipFinalSnapshot", skipFinalSnapshot)
    def getFinalDBSnapshotIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("finalDBSnapshotIdentifier", finalDBSnapshotIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterRequest
  ) extends zio.aws.rds.model.DeleteDbClusterRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val skipFinalSnapshot: scala.Option[Boolean] =
      scala.Option(impl.skipFinalSnapshot()).map(value => value: Boolean)
    override val finalDBSnapshotIdentifier: scala.Option[String] =
      scala.Option(impl.finalDBSnapshotIdentifier()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterRequest
  ): zio.aws.rds.model.DeleteDbClusterRequest.ReadOnly = new Wrapper(impl)
}
