package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteCustomAvailabilityZoneRequest(
    customAvailabilityZoneId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteCustomAvailabilityZoneRequest = {
    import DeleteCustomAvailabilityZoneRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteCustomAvailabilityZoneRequest
      .builder()
      .customAvailabilityZoneId(customAvailabilityZoneId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DeleteCustomAvailabilityZoneRequest.ReadOnly =
    zio.aws.rds.model.DeleteCustomAvailabilityZoneRequest.wrap(buildAwsValue())
}
object DeleteCustomAvailabilityZoneRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteCustomAvailabilityZoneRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteCustomAvailabilityZoneRequest =
      zio.aws.rds.model
        .DeleteCustomAvailabilityZoneRequest(customAvailabilityZoneId)
    def customAvailabilityZoneId: String
    def getCustomAvailabilityZoneId: ZIO[Any, Nothing, String] =
      ZIO.succeed(customAvailabilityZoneId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteCustomAvailabilityZoneRequest
  ) extends zio.aws.rds.model.DeleteCustomAvailabilityZoneRequest.ReadOnly {
    override val customAvailabilityZoneId: String =
      impl.customAvailabilityZoneId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteCustomAvailabilityZoneRequest
  ): zio.aws.rds.model.DeleteCustomAvailabilityZoneRequest.ReadOnly =
    new Wrapper(impl)
}
