package zio.aws.rds.model
import zio.aws.rds.model.primitives.{TStamp, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DBProxy(
    dbProxyName: scala.Option[String] = None,
    dbProxyArn: scala.Option[String] = None,
    status: scala.Option[zio.aws.rds.model.DBProxyStatus] = None,
    engineFamily: scala.Option[String] = None,
    vpcId: scala.Option[String] = None,
    vpcSecurityGroupIds: scala.Option[Iterable[String]] = None,
    vpcSubnetIds: scala.Option[Iterable[String]] = None,
    auth: scala.Option[Iterable[zio.aws.rds.model.UserAuthConfigInfo]] = None,
    roleArn: scala.Option[String] = None,
    endpoint: scala.Option[String] = None,
    requireTLS: scala.Option[Boolean] = None,
    idleClientTimeout: scala.Option[Integer] = None,
    debugLogging: scala.Option[Boolean] = None,
    createdDate: scala.Option[TStamp] = None,
    updatedDate: scala.Option[TStamp] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBProxy = {
    import DBProxy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBProxy
      .builder()
      .optionallyWith(dbProxyName.map(value => value: java.lang.String))(
        _.dbProxyName
      )
      .optionallyWith(dbProxyArn.map(value => value: java.lang.String))(
        _.dbProxyArn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(engineFamily.map(value => value: java.lang.String))(
        _.engineFamily
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(
        vpcSubnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSubnetIds)
      .optionallyWith(
        auth.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.auth)
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(requireTLS.map(value => value: java.lang.Boolean))(
        _.requireTLS
      )
      .optionallyWith(
        idleClientTimeout.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.idleClientTimeout)
      .optionallyWith(debugLogging.map(value => value: java.lang.Boolean))(
        _.debugLogging
      )
      .optionallyWith(createdDate.map(value => TStamp.unwrap(value): Instant))(
        _.createdDate
      )
      .optionallyWith(updatedDate.map(value => TStamp.unwrap(value): Instant))(
        _.updatedDate
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBProxy.ReadOnly =
    zio.aws.rds.model.DBProxy.wrap(buildAwsValue())
}
object DBProxy {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.DBProxy] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBProxy = zio.aws.rds.model.DBProxy(
      dbProxyName.map(value => value),
      dbProxyArn.map(value => value),
      status.map(value => value),
      engineFamily.map(value => value),
      vpcId.map(value => value),
      vpcSecurityGroupIds.map(value => value),
      vpcSubnetIds.map(value => value),
      auth.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      roleArn.map(value => value),
      endpoint.map(value => value),
      requireTLS.map(value => value),
      idleClientTimeout.map(value => value),
      debugLogging.map(value => value),
      createdDate.map(value => value),
      updatedDate.map(value => value)
    )
    def dbProxyName: scala.Option[String]
    def dbProxyArn: scala.Option[String]
    def status: scala.Option[zio.aws.rds.model.DBProxyStatus]
    def engineFamily: scala.Option[String]
    def vpcId: scala.Option[String]
    def vpcSecurityGroupIds: scala.Option[List[String]]
    def vpcSubnetIds: scala.Option[List[String]]
    def auth: scala.Option[List[zio.aws.rds.model.UserAuthConfigInfo.ReadOnly]]
    def roleArn: scala.Option[String]
    def endpoint: scala.Option[String]
    def requireTLS: scala.Option[Boolean]
    def idleClientTimeout: scala.Option[Integer]
    def debugLogging: scala.Option[Boolean]
    def createdDate: scala.Option[TStamp]
    def updatedDate: scala.Option[TStamp]
    def getDbProxyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbProxyName", dbProxyName)
    def getDbProxyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbProxyArn", dbProxyArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.rds.model.DBProxyStatus] =
      AwsError.unwrapOptionField("status", status)
    def getEngineFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineFamily", engineFamily)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getVpcSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSubnetIds", vpcSubnetIds)
    def getAuth: ZIO[Any, AwsError, List[
      zio.aws.rds.model.UserAuthConfigInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("auth", auth)
    def getRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getRequireTLS: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requireTLS", requireTLS)
    def getIdleClientTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("idleClientTimeout", idleClientTimeout)
    def getDebugLogging: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("debugLogging", debugLogging)
    def getCreatedDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getUpdatedDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("updatedDate", updatedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBProxy
  ) extends zio.aws.rds.model.DBProxy.ReadOnly {
    override val dbProxyName: scala.Option[String] =
      scala.Option(impl.dbProxyName()).map(value => value: String)
    override val dbProxyArn: scala.Option[String] =
      scala.Option(impl.dbProxyArn()).map(value => value: String)
    override val status: scala.Option[zio.aws.rds.model.DBProxyStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.rds.model.DBProxyStatus.wrap(value))
    override val engineFamily: scala.Option[String] =
      scala.Option(impl.engineFamily()).map(value => value: String)
    override val vpcId: scala.Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val vpcSecurityGroupIds: scala.Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val vpcSubnetIds: scala.Option[List[String]] = scala
      .Option(impl.vpcSubnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val auth
        : scala.Option[List[zio.aws.rds.model.UserAuthConfigInfo.ReadOnly]] =
      scala
        .Option(impl.auth())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.UserAuthConfigInfo.wrap(item)
          }.toList
        )
    override val roleArn: scala.Option[String] =
      scala.Option(impl.roleArn()).map(value => value: String)
    override val endpoint: scala.Option[String] =
      scala.Option(impl.endpoint()).map(value => value: String)
    override val requireTLS: scala.Option[Boolean] =
      scala.Option(impl.requireTLS()).map(value => value: Boolean)
    override val idleClientTimeout: scala.Option[Integer] = scala
      .Option(impl.idleClientTimeout())
      .map(value => zio.aws.rds.model.primitives.Integer(value))
    override val debugLogging: scala.Option[Boolean] =
      scala.Option(impl.debugLogging()).map(value => value: Boolean)
    override val createdDate: scala.Option[TStamp] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val updatedDate: scala.Option[TStamp] = scala
      .Option(impl.updatedDate())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBProxy
  ): zio.aws.rds.model.DBProxy.ReadOnly = new Wrapper(impl)
}
