package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DBInstanceStatusInfo(
    statusType: scala.Option[String] = None,
    normal: scala.Option[Boolean] = None,
    status: scala.Option[String] = None,
    message: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBInstanceStatusInfo = {
    import DBInstanceStatusInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBInstanceStatusInfo
      .builder()
      .optionallyWith(statusType.map(value => value: java.lang.String))(
        _.statusType
      )
      .optionallyWith(normal.map(value => value: java.lang.Boolean))(_.normal)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBInstanceStatusInfo.ReadOnly =
    zio.aws.rds.model.DBInstanceStatusInfo.wrap(buildAwsValue())
}
object DBInstanceStatusInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBInstanceStatusInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBInstanceStatusInfo =
      zio.aws.rds.model.DBInstanceStatusInfo(
        statusType.map(value => value),
        normal.map(value => value),
        status.map(value => value),
        message.map(value => value)
      )
    def statusType: scala.Option[String]
    def normal: scala.Option[Boolean]
    def status: scala.Option[String]
    def message: scala.Option[String]
    def getStatusType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusType", statusType)
    def getNormal: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("normal", normal)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBInstanceStatusInfo
  ) extends zio.aws.rds.model.DBInstanceStatusInfo.ReadOnly {
    override val statusType: scala.Option[String] =
      scala.Option(impl.statusType()).map(value => value: String)
    override val normal: scala.Option[Boolean] =
      scala.Option(impl.normal()).map(value => value: Boolean)
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val message: scala.Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBInstanceStatusInfo
  ): zio.aws.rds.model.DBInstanceStatusInfo.ReadOnly = new Wrapper(impl)
}
