package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DBClusterSnapshotAttributesResult(
    dbClusterSnapshotIdentifier: scala.Option[String] = None,
    dbClusterSnapshotAttributes: scala.Option[Iterable[
      zio.aws.rds.model.DBClusterSnapshotAttribute
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttributesResult = {
    import DBClusterSnapshotAttributesResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttributesResult
      .builder()
      .optionallyWith(
        dbClusterSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterSnapshotIdentifier)
      .optionallyWith(
        dbClusterSnapshotAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterSnapshotAttributes)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBClusterSnapshotAttributesResult.ReadOnly =
    zio.aws.rds.model.DBClusterSnapshotAttributesResult.wrap(buildAwsValue())
}
object DBClusterSnapshotAttributesResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttributesResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBClusterSnapshotAttributesResult =
      zio.aws.rds.model.DBClusterSnapshotAttributesResult(
        dbClusterSnapshotIdentifier.map(value => value),
        dbClusterSnapshotAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbClusterSnapshotIdentifier: scala.Option[String]
    def dbClusterSnapshotAttributes: scala.Option[List[
      zio.aws.rds.model.DBClusterSnapshotAttribute.ReadOnly
    ]]
    def getDbClusterSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterSnapshotIdentifier",
        dbClusterSnapshotIdentifier
      )
    def getDbClusterSnapshotAttributes: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBClusterSnapshotAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dbClusterSnapshotAttributes",
      dbClusterSnapshotAttributes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttributesResult
  ) extends zio.aws.rds.model.DBClusterSnapshotAttributesResult.ReadOnly {
    override val dbClusterSnapshotIdentifier: scala.Option[String] = scala
      .Option(impl.dbClusterSnapshotIdentifier())
      .map(value => value: String)
    override val dbClusterSnapshotAttributes: scala.Option[List[
      zio.aws.rds.model.DBClusterSnapshotAttribute.ReadOnly
    ]] = scala
      .Option(impl.dbClusterSnapshotAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBClusterSnapshotAttribute.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttributesResult
  ): zio.aws.rds.model.DBClusterSnapshotAttributesResult.ReadOnly = new Wrapper(
    impl
  )
}
