package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AddSourceIdentifierToSubscriptionRequest(
    subscriptionName: String,
    sourceIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionRequest = {
    import AddSourceIdentifierToSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionRequest
      .builder()
      .subscriptionName(subscriptionName: java.lang.String)
      .sourceIdentifier(sourceIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.AddSourceIdentifierToSubscriptionRequest.ReadOnly =
    zio.aws.rds.model.AddSourceIdentifierToSubscriptionRequest
      .wrap(buildAwsValue())
}
object AddSourceIdentifierToSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.AddSourceIdentifierToSubscriptionRequest =
      zio.aws.rds.model.AddSourceIdentifierToSubscriptionRequest(
        subscriptionName,
        sourceIdentifier
      )
    def subscriptionName: String
    def sourceIdentifier: String
    def getSubscriptionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(subscriptionName)
    def getSourceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionRequest
  ) extends zio.aws.rds.model.AddSourceIdentifierToSubscriptionRequest.ReadOnly {
    override val subscriptionName: String = impl.subscriptionName(): String
    override val sourceIdentifier: String = impl.sourceIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionRequest
  ): zio.aws.rds.model.AddSourceIdentifierToSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
