package zio.aws.rds.model
import scala.jdk.CollectionConverters.*
sealed trait TargetHealthReason {
  def unwrap: software.amazon.awssdk.services.rds.model.TargetHealthReason
}
object TargetHealthReason {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.TargetHealthReason
  ): zio.aws.rds.model.TargetHealthReason = value match {
    case software.amazon.awssdk.services.rds.model.TargetHealthReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.TargetHealthReason.UNREACHABLE =>
      val r = UNREACHABLE
      r
    case software.amazon.awssdk.services.rds.model.TargetHealthReason.CONNECTION_FAILED =>
      val r = CONNECTION_FAILED
      r
    case software.amazon.awssdk.services.rds.model.TargetHealthReason.AUTH_FAILURE =>
      val r = AUTH_FAILURE
      r
    case software.amazon.awssdk.services.rds.model.TargetHealthReason.PENDING_PROXY_CAPACITY =>
      val r = PENDING_PROXY_CAPACITY
      r
    case software.amazon.awssdk.services.rds.model.TargetHealthReason.INVALID_REPLICATION_STATE =>
      val r = INVALID_REPLICATION_STATE
      r
  }
  case object unknownToSdkVersion extends zio.aws.rds.model.TargetHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.TargetHealthReason =
      software.amazon.awssdk.services.rds.model.TargetHealthReason.UNKNOWN_TO_SDK_VERSION
  }
  case object UNREACHABLE extends zio.aws.rds.model.TargetHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.TargetHealthReason =
      software.amazon.awssdk.services.rds.model.TargetHealthReason.UNREACHABLE
  }
  case object CONNECTION_FAILED extends zio.aws.rds.model.TargetHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.TargetHealthReason =
      software.amazon.awssdk.services.rds.model.TargetHealthReason.CONNECTION_FAILED
  }
  case object AUTH_FAILURE extends zio.aws.rds.model.TargetHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.TargetHealthReason =
      software.amazon.awssdk.services.rds.model.TargetHealthReason.AUTH_FAILURE
  }
  case object PENDING_PROXY_CAPACITY
      extends zio.aws.rds.model.TargetHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.TargetHealthReason =
      software.amazon.awssdk.services.rds.model.TargetHealthReason.PENDING_PROXY_CAPACITY
  }
  case object INVALID_REPLICATION_STATE
      extends zio.aws.rds.model.TargetHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.TargetHealthReason =
      software.amazon.awssdk.services.rds.model.TargetHealthReason.INVALID_REPLICATION_STATE
  }
}
