package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TargetHealth(
    state: scala.Option[zio.aws.rds.model.TargetState] = None,
    reason: scala.Option[zio.aws.rds.model.TargetHealthReason] = None,
    description: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.TargetHealth = {
    import TargetHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.TargetHealth
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(reason.map(value => value.unwrap))(_.reason)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.TargetHealth.ReadOnly =
    zio.aws.rds.model.TargetHealth.wrap(buildAwsValue())
}
object TargetHealth {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.TargetHealth] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.TargetHealth =
      zio.aws.rds.model.TargetHealth(
        state.map(value => value),
        reason.map(value => value),
        description.map(value => value)
      )
    def state: scala.Option[zio.aws.rds.model.TargetState]
    def reason: scala.Option[zio.aws.rds.model.TargetHealthReason]
    def description: scala.Option[String]
    def getState: ZIO[Any, AwsError, zio.aws.rds.model.TargetState] =
      AwsError.unwrapOptionField("state", state)
    def getReason: ZIO[Any, AwsError, zio.aws.rds.model.TargetHealthReason] =
      AwsError.unwrapOptionField("reason", reason)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.TargetHealth
  ) extends zio.aws.rds.model.TargetHealth.ReadOnly {
    override val state: scala.Option[zio.aws.rds.model.TargetState] = scala
      .Option(impl.state())
      .map(value => zio.aws.rds.model.TargetState.wrap(value))
    override val reason: scala.Option[zio.aws.rds.model.TargetHealthReason] =
      scala
        .Option(impl.reason())
        .map(value => zio.aws.rds.model.TargetHealthReason.wrap(value))
    override val description: scala.Option[String] =
      scala.Option(impl.description()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.TargetHealth
  ): zio.aws.rds.model.TargetHealth.ReadOnly = new Wrapper(impl)
}
