package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RevokeDbSecurityGroupIngressResponse(
    dbSecurityGroup: scala.Option[zio.aws.rds.model.DBSecurityGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RevokeDbSecurityGroupIngressResponse = {
    import RevokeDbSecurityGroupIngressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RevokeDbSecurityGroupIngressResponse
      .builder()
      .optionallyWith(dbSecurityGroup.map(value => value.buildAwsValue()))(
        _.dbSecurityGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.RevokeDbSecurityGroupIngressResponse.ReadOnly =
    zio.aws.rds.model.RevokeDbSecurityGroupIngressResponse.wrap(buildAwsValue())
}
object RevokeDbSecurityGroupIngressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RevokeDbSecurityGroupIngressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RevokeDbSecurityGroupIngressResponse =
      zio.aws.rds.model.RevokeDbSecurityGroupIngressResponse(
        dbSecurityGroup.map(value => value.asEditable)
      )
    def dbSecurityGroup
        : scala.Option[zio.aws.rds.model.DBSecurityGroup.ReadOnly]
    def getDbSecurityGroup
        : ZIO[Any, AwsError, zio.aws.rds.model.DBSecurityGroup.ReadOnly] =
      AwsError.unwrapOptionField("dbSecurityGroup", dbSecurityGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RevokeDbSecurityGroupIngressResponse
  ) extends zio.aws.rds.model.RevokeDbSecurityGroupIngressResponse.ReadOnly {
    override val dbSecurityGroup
        : scala.Option[zio.aws.rds.model.DBSecurityGroup.ReadOnly] = scala
      .Option(impl.dbSecurityGroup())
      .map(value => zio.aws.rds.model.DBSecurityGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RevokeDbSecurityGroupIngressResponse
  ): zio.aws.rds.model.RevokeDbSecurityGroupIngressResponse.ReadOnly =
    new Wrapper(impl)
}
