package zio.aws.rds.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{BooleanOptional, IntegerOptional, TStamp}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RestoreDbInstanceToPointInTimeRequest(
    sourceDBInstanceIdentifier: scala.Option[String] = None,
    targetDBInstanceIdentifier: String,
    restoreTime: scala.Option[TStamp] = None,
    useLatestRestorableTime: scala.Option[Boolean] = None,
    dbInstanceClass: scala.Option[String] = None,
    port: scala.Option[IntegerOptional] = None,
    availabilityZone: scala.Option[String] = None,
    dbSubnetGroupName: scala.Option[String] = None,
    multiAZ: scala.Option[BooleanOptional] = None,
    publiclyAccessible: scala.Option[BooleanOptional] = None,
    autoMinorVersionUpgrade: scala.Option[BooleanOptional] = None,
    licenseModel: scala.Option[String] = None,
    dbName: scala.Option[String] = None,
    engine: scala.Option[String] = None,
    iops: scala.Option[IntegerOptional] = None,
    optionGroupName: scala.Option[String] = None,
    copyTagsToSnapshot: scala.Option[BooleanOptional] = None,
    tags: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None,
    storageType: scala.Option[String] = None,
    tdeCredentialArn: scala.Option[String] = None,
    tdeCredentialPassword: scala.Option[String] = None,
    vpcSecurityGroupIds: scala.Option[Iterable[String]] = None,
    domain: scala.Option[String] = None,
    domainIAMRoleName: scala.Option[String] = None,
    enableIAMDatabaseAuthentication: scala.Option[BooleanOptional] = None,
    enableCloudwatchLogsExports: scala.Option[Iterable[String]] = None,
    processorFeatures: scala.Option[Iterable[
      zio.aws.rds.model.ProcessorFeature
    ]] = None,
    useDefaultProcessorFeatures: scala.Option[BooleanOptional] = None,
    dbParameterGroupName: scala.Option[String] = None,
    deletionProtection: scala.Option[BooleanOptional] = None,
    sourceDbiResourceId: scala.Option[String] = None,
    maxAllocatedStorage: scala.Option[IntegerOptional] = None,
    sourceDBInstanceAutomatedBackupsArn: scala.Option[String] = None,
    enableCustomerOwnedIp: scala.Option[BooleanOptional] = None,
    customIamInstanceProfile: scala.Option[String] = None,
    backupTarget: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeRequest = {
    import RestoreDbInstanceToPointInTimeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeRequest
      .builder()
      .optionallyWith(
        sourceDBInstanceIdentifier.map(value => value: java.lang.String)
      )(_.sourceDBInstanceIdentifier)
      .targetDBInstanceIdentifier(targetDBInstanceIdentifier: java.lang.String)
      .optionallyWith(restoreTime.map(value => TStamp.unwrap(value): Instant))(
        _.restoreTime
      )
      .optionallyWith(
        useLatestRestorableTime.map(value => value: java.lang.Boolean)
      )(_.useLatestRestorableTime)
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(
        multiAZ.map(value => BooleanOptional.unwrap(value): java.lang.Boolean)
      )(_.multiAZ)
      .optionallyWith(
        publiclyAccessible.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.publiclyAccessible)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(
        iops.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.iops)
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        copyTagsToSnapshot.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.copyTagsToSnapshot)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(tdeCredentialArn.map(value => value: java.lang.String))(
        _.tdeCredentialArn
      )
      .optionallyWith(
        tdeCredentialPassword.map(value => value: java.lang.String)
      )(_.tdeCredentialPassword)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(
        _.domainIAMRoleName
      )
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.enableIAMDatabaseAuthentication)
      .optionallyWith(
        enableCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableCloudwatchLogsExports)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .optionallyWith(
        useDefaultProcessorFeatures.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.useDefaultProcessorFeatures)
      .optionallyWith(
        dbParameterGroupName.map(value => value: java.lang.String)
      )(_.dbParameterGroupName)
      .optionallyWith(
        deletionProtection.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.deletionProtection)
      .optionallyWith(
        sourceDbiResourceId.map(value => value: java.lang.String)
      )(_.sourceDbiResourceId)
      .optionallyWith(
        maxAllocatedStorage.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxAllocatedStorage)
      .optionallyWith(
        sourceDBInstanceAutomatedBackupsArn.map(value =>
          value: java.lang.String
        )
      )(_.sourceDBInstanceAutomatedBackupsArn)
      .optionallyWith(
        enableCustomerOwnedIp.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.enableCustomerOwnedIp)
      .optionallyWith(
        customIamInstanceProfile.map(value => value: java.lang.String)
      )(_.customIamInstanceProfile)
      .optionallyWith(backupTarget.map(value => value: java.lang.String))(
        _.backupTarget
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.RestoreDbInstanceToPointInTimeRequest.ReadOnly =
    zio.aws.rds.model.RestoreDbInstanceToPointInTimeRequest
      .wrap(buildAwsValue())
}
object RestoreDbInstanceToPointInTimeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RestoreDbInstanceToPointInTimeRequest =
      zio.aws.rds.model.RestoreDbInstanceToPointInTimeRequest(
        sourceDBInstanceIdentifier.map(value => value),
        targetDBInstanceIdentifier,
        restoreTime.map(value => value),
        useLatestRestorableTime.map(value => value),
        dbInstanceClass.map(value => value),
        port.map(value => value),
        availabilityZone.map(value => value),
        dbSubnetGroupName.map(value => value),
        multiAZ.map(value => value),
        publiclyAccessible.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        licenseModel.map(value => value),
        dbName.map(value => value),
        engine.map(value => value),
        iops.map(value => value),
        optionGroupName.map(value => value),
        copyTagsToSnapshot.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        storageType.map(value => value),
        tdeCredentialArn.map(value => value),
        tdeCredentialPassword.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        domain.map(value => value),
        domainIAMRoleName.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        enableCloudwatchLogsExports.map(value => value),
        processorFeatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        useDefaultProcessorFeatures.map(value => value),
        dbParameterGroupName.map(value => value),
        deletionProtection.map(value => value),
        sourceDbiResourceId.map(value => value),
        maxAllocatedStorage.map(value => value),
        sourceDBInstanceAutomatedBackupsArn.map(value => value),
        enableCustomerOwnedIp.map(value => value),
        customIamInstanceProfile.map(value => value),
        backupTarget.map(value => value)
      )
    def sourceDBInstanceIdentifier: scala.Option[String]
    def targetDBInstanceIdentifier: String
    def restoreTime: scala.Option[TStamp]
    def useLatestRestorableTime: scala.Option[Boolean]
    def dbInstanceClass: scala.Option[String]
    def port: scala.Option[IntegerOptional]
    def availabilityZone: scala.Option[String]
    def dbSubnetGroupName: scala.Option[String]
    def multiAZ: scala.Option[BooleanOptional]
    def publiclyAccessible: scala.Option[BooleanOptional]
    def autoMinorVersionUpgrade: scala.Option[BooleanOptional]
    def licenseModel: scala.Option[String]
    def dbName: scala.Option[String]
    def engine: scala.Option[String]
    def iops: scala.Option[IntegerOptional]
    def optionGroupName: scala.Option[String]
    def copyTagsToSnapshot: scala.Option[BooleanOptional]
    def tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def storageType: scala.Option[String]
    def tdeCredentialArn: scala.Option[String]
    def tdeCredentialPassword: scala.Option[String]
    def vpcSecurityGroupIds: scala.Option[List[String]]
    def domain: scala.Option[String]
    def domainIAMRoleName: scala.Option[String]
    def enableIAMDatabaseAuthentication: scala.Option[BooleanOptional]
    def enableCloudwatchLogsExports: scala.Option[List[String]]
    def processorFeatures
        : scala.Option[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]]
    def useDefaultProcessorFeatures: scala.Option[BooleanOptional]
    def dbParameterGroupName: scala.Option[String]
    def deletionProtection: scala.Option[BooleanOptional]
    def sourceDbiResourceId: scala.Option[String]
    def maxAllocatedStorage: scala.Option[IntegerOptional]
    def sourceDBInstanceAutomatedBackupsArn: scala.Option[String]
    def enableCustomerOwnedIp: scala.Option[BooleanOptional]
    def customIamInstanceProfile: scala.Option[String]
    def backupTarget: scala.Option[String]
    def getSourceDBInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "sourceDBInstanceIdentifier",
        sourceDBInstanceIdentifier
      )
    def getTargetDBInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetDBInstanceIdentifier)
    def getRestoreTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("restoreTime", restoreTime)
    def getUseLatestRestorableTime: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("useLatestRestorableTime", useLatestRestorableTime)
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getTdeCredentialArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArn)
    def getTdeCredentialPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tdeCredentialPassword", tdeCredentialPassword)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getDomainIAMRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleName)
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getEnableCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enableCloudwatchLogsExports",
        enableCloudwatchLogsExports
      )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
    def getUseDefaultProcessorFeatures: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "useDefaultProcessorFeatures",
        useDefaultProcessorFeatures
      )
    def getDbParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupName)
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getSourceDbiResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceDbiResourceId", sourceDbiResourceId)
    def getMaxAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxAllocatedStorage", maxAllocatedStorage)
    def getSourceDBInstanceAutomatedBackupsArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "sourceDBInstanceAutomatedBackupsArn",
        sourceDBInstanceAutomatedBackupsArn
      )
    def getEnableCustomerOwnedIp: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enableCustomerOwnedIp", enableCustomerOwnedIp)
    def getCustomIamInstanceProfile: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("customIamInstanceProfile", customIamInstanceProfile)
    def getBackupTarget: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupTarget", backupTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeRequest
  ) extends zio.aws.rds.model.RestoreDbInstanceToPointInTimeRequest.ReadOnly {
    override val sourceDBInstanceIdentifier: scala.Option[String] = scala
      .Option(impl.sourceDBInstanceIdentifier())
      .map(value => value: String)
    override val targetDBInstanceIdentifier: String =
      impl.targetDBInstanceIdentifier(): String
    override val restoreTime: scala.Option[TStamp] = scala
      .Option(impl.restoreTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val useLatestRestorableTime: scala.Option[Boolean] =
      scala.Option(impl.useLatestRestorableTime()).map(value => value: Boolean)
    override val dbInstanceClass: scala.Option[String] =
      scala.Option(impl.dbInstanceClass()).map(value => value: String)
    override val port: scala.Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val availabilityZone: scala.Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val dbSubnetGroupName: scala.Option[String] =
      scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
    override val multiAZ: scala.Option[BooleanOptional] = scala
      .Option(impl.multiAZ())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val publiclyAccessible: scala.Option[BooleanOptional] = scala
      .Option(impl.publiclyAccessible())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val autoMinorVersionUpgrade: scala.Option[BooleanOptional] = scala
      .Option(impl.autoMinorVersionUpgrade())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val licenseModel: scala.Option[String] =
      scala.Option(impl.licenseModel()).map(value => value: String)
    override val dbName: scala.Option[String] =
      scala.Option(impl.dbName()).map(value => value: String)
    override val engine: scala.Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val iops: scala.Option[IntegerOptional] = scala
      .Option(impl.iops())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val optionGroupName: scala.Option[String] =
      scala.Option(impl.optionGroupName()).map(value => value: String)
    override val copyTagsToSnapshot: scala.Option[BooleanOptional] = scala
      .Option(impl.copyTagsToSnapshot())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val storageType: scala.Option[String] =
      scala.Option(impl.storageType()).map(value => value: String)
    override val tdeCredentialArn: scala.Option[String] =
      scala.Option(impl.tdeCredentialArn()).map(value => value: String)
    override val tdeCredentialPassword: scala.Option[String] =
      scala.Option(impl.tdeCredentialPassword()).map(value => value: String)
    override val vpcSecurityGroupIds: scala.Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val domain: scala.Option[String] =
      scala.Option(impl.domain()).map(value => value: String)
    override val domainIAMRoleName: scala.Option[String] =
      scala.Option(impl.domainIAMRoleName()).map(value => value: String)
    override val enableIAMDatabaseAuthentication
        : scala.Option[BooleanOptional] = scala
      .Option(impl.enableIAMDatabaseAuthentication())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val enableCloudwatchLogsExports: scala.Option[List[String]] = scala
      .Option(impl.enableCloudwatchLogsExports())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val processorFeatures
        : scala.Option[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]] =
      scala
        .Option(impl.processorFeatures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.ProcessorFeature.wrap(item)
          }.toList
        )
    override val useDefaultProcessorFeatures: scala.Option[BooleanOptional] =
      scala
        .Option(impl.useDefaultProcessorFeatures())
        .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val dbParameterGroupName: scala.Option[String] =
      scala.Option(impl.dbParameterGroupName()).map(value => value: String)
    override val deletionProtection: scala.Option[BooleanOptional] = scala
      .Option(impl.deletionProtection())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val sourceDbiResourceId: scala.Option[String] =
      scala.Option(impl.sourceDbiResourceId()).map(value => value: String)
    override val maxAllocatedStorage: scala.Option[IntegerOptional] = scala
      .Option(impl.maxAllocatedStorage())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val sourceDBInstanceAutomatedBackupsArn: scala.Option[String] =
      scala
        .Option(impl.sourceDBInstanceAutomatedBackupsArn())
        .map(value => value: String)
    override val enableCustomerOwnedIp: scala.Option[BooleanOptional] = scala
      .Option(impl.enableCustomerOwnedIp())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val customIamInstanceProfile: scala.Option[String] =
      scala.Option(impl.customIamInstanceProfile()).map(value => value: String)
    override val backupTarget: scala.Option[String] =
      scala.Option(impl.backupTarget()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeRequest
  ): zio.aws.rds.model.RestoreDbInstanceToPointInTimeRequest.ReadOnly =
    new Wrapper(impl)
}
