package zio.aws.rds.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{
  LongOptional,
  BooleanOptional,
  IntegerOptional,
  TStamp
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RestoreDbClusterToPointInTimeRequest(
    dbClusterIdentifier: String,
    restoreType: scala.Option[String] = None,
    sourceDBClusterIdentifier: String,
    restoreToTime: scala.Option[TStamp] = None,
    useLatestRestorableTime: scala.Option[Boolean] = None,
    port: scala.Option[IntegerOptional] = None,
    dbSubnetGroupName: scala.Option[String] = None,
    optionGroupName: scala.Option[String] = None,
    vpcSecurityGroupIds: scala.Option[Iterable[String]] = None,
    tags: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None,
    kmsKeyId: scala.Option[String] = None,
    enableIAMDatabaseAuthentication: scala.Option[BooleanOptional] = None,
    backtrackWindow: scala.Option[LongOptional] = None,
    enableCloudwatchLogsExports: scala.Option[Iterable[String]] = None,
    dbClusterParameterGroupName: scala.Option[String] = None,
    deletionProtection: scala.Option[BooleanOptional] = None,
    copyTagsToSnapshot: scala.Option[BooleanOptional] = None,
    domain: scala.Option[String] = None,
    domainIAMRoleName: scala.Option[String] = None,
    scalingConfiguration: scala.Option[zio.aws.rds.model.ScalingConfiguration] =
      None,
    engineMode: scala.Option[String] = None,
    dbClusterInstanceClass: scala.Option[String] = None,
    storageType: scala.Option[String] = None,
    publiclyAccessible: scala.Option[BooleanOptional] = None,
    iops: scala.Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeRequest = {
    import RestoreDbClusterToPointInTimeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(restoreType.map(value => value: java.lang.String))(
        _.restoreType
      )
      .sourceDBClusterIdentifier(sourceDBClusterIdentifier: java.lang.String)
      .optionallyWith(
        restoreToTime.map(value => TStamp.unwrap(value): Instant)
      )(_.restoreToTime)
      .optionallyWith(
        useLatestRestorableTime.map(value => value: java.lang.Boolean)
      )(_.useLatestRestorableTime)
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.enableIAMDatabaseAuthentication)
      .optionallyWith(
        backtrackWindow.map(value => LongOptional.unwrap(value): java.lang.Long)
      )(_.backtrackWindow)
      .optionallyWith(
        enableCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableCloudwatchLogsExports)
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .optionallyWith(
        deletionProtection.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.deletionProtection)
      .optionallyWith(
        copyTagsToSnapshot.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.copyTagsToSnapshot)
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(
        _.domainIAMRoleName
      )
      .optionallyWith(scalingConfiguration.map(value => value.buildAwsValue()))(
        _.scalingConfiguration
      )
      .optionallyWith(engineMode.map(value => value: java.lang.String))(
        _.engineMode
      )
      .optionallyWith(
        dbClusterInstanceClass.map(value => value: java.lang.String)
      )(_.dbClusterInstanceClass)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(
        publiclyAccessible.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.publiclyAccessible)
      .optionallyWith(
        iops.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.iops)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.RestoreDbClusterToPointInTimeRequest.ReadOnly =
    zio.aws.rds.model.RestoreDbClusterToPointInTimeRequest.wrap(buildAwsValue())
}
object RestoreDbClusterToPointInTimeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RestoreDbClusterToPointInTimeRequest =
      zio.aws.rds.model.RestoreDbClusterToPointInTimeRequest(
        dbClusterIdentifier,
        restoreType.map(value => value),
        sourceDBClusterIdentifier,
        restoreToTime.map(value => value),
        useLatestRestorableTime.map(value => value),
        port.map(value => value),
        dbSubnetGroupName.map(value => value),
        optionGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        backtrackWindow.map(value => value),
        enableCloudwatchLogsExports.map(value => value),
        dbClusterParameterGroupName.map(value => value),
        deletionProtection.map(value => value),
        copyTagsToSnapshot.map(value => value),
        domain.map(value => value),
        domainIAMRoleName.map(value => value),
        scalingConfiguration.map(value => value.asEditable),
        engineMode.map(value => value),
        dbClusterInstanceClass.map(value => value),
        storageType.map(value => value),
        publiclyAccessible.map(value => value),
        iops.map(value => value)
      )
    def dbClusterIdentifier: String
    def restoreType: scala.Option[String]
    def sourceDBClusterIdentifier: String
    def restoreToTime: scala.Option[TStamp]
    def useLatestRestorableTime: scala.Option[Boolean]
    def port: scala.Option[IntegerOptional]
    def dbSubnetGroupName: scala.Option[String]
    def optionGroupName: scala.Option[String]
    def vpcSecurityGroupIds: scala.Option[List[String]]
    def tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def kmsKeyId: scala.Option[String]
    def enableIAMDatabaseAuthentication: scala.Option[BooleanOptional]
    def backtrackWindow: scala.Option[LongOptional]
    def enableCloudwatchLogsExports: scala.Option[List[String]]
    def dbClusterParameterGroupName: scala.Option[String]
    def deletionProtection: scala.Option[BooleanOptional]
    def copyTagsToSnapshot: scala.Option[BooleanOptional]
    def domain: scala.Option[String]
    def domainIAMRoleName: scala.Option[String]
    def scalingConfiguration
        : scala.Option[zio.aws.rds.model.ScalingConfiguration.ReadOnly]
    def engineMode: scala.Option[String]
    def dbClusterInstanceClass: scala.Option[String]
    def storageType: scala.Option[String]
    def publiclyAccessible: scala.Option[BooleanOptional]
    def iops: scala.Option[IntegerOptional]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getRestoreType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("restoreType", restoreType)
    def getSourceDBClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceDBClusterIdentifier)
    def getRestoreToTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("restoreToTime", restoreToTime)
    def getUseLatestRestorableTime: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("useLatestRestorableTime", useLatestRestorableTime)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getBacktrackWindow: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("backtrackWindow", backtrackWindow)
    def getEnableCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enableCloudwatchLogsExports",
        enableCloudwatchLogsExports
      )
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getDomainIAMRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleName)
    def getScalingConfiguration
        : ZIO[Any, AwsError, zio.aws.rds.model.ScalingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("scalingConfiguration", scalingConfiguration)
    def getEngineMode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineMode", engineMode)
    def getDbClusterInstanceClass: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbClusterInstanceClass", dbClusterInstanceClass)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeRequest
  ) extends zio.aws.rds.model.RestoreDbClusterToPointInTimeRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val restoreType: scala.Option[String] =
      scala.Option(impl.restoreType()).map(value => value: String)
    override val sourceDBClusterIdentifier: String =
      impl.sourceDBClusterIdentifier(): String
    override val restoreToTime: scala.Option[TStamp] = scala
      .Option(impl.restoreToTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val useLatestRestorableTime: scala.Option[Boolean] =
      scala.Option(impl.useLatestRestorableTime()).map(value => value: Boolean)
    override val port: scala.Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val dbSubnetGroupName: scala.Option[String] =
      scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
    override val optionGroupName: scala.Option[String] =
      scala.Option(impl.optionGroupName()).map(value => value: String)
    override val vpcSecurityGroupIds: scala.Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val kmsKeyId: scala.Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val enableIAMDatabaseAuthentication
        : scala.Option[BooleanOptional] = scala
      .Option(impl.enableIAMDatabaseAuthentication())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val backtrackWindow: scala.Option[LongOptional] = scala
      .Option(impl.backtrackWindow())
      .map(value => zio.aws.rds.model.primitives.LongOptional(value))
    override val enableCloudwatchLogsExports: scala.Option[List[String]] = scala
      .Option(impl.enableCloudwatchLogsExports())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val dbClusterParameterGroupName: scala.Option[String] = scala
      .Option(impl.dbClusterParameterGroupName())
      .map(value => value: String)
    override val deletionProtection: scala.Option[BooleanOptional] = scala
      .Option(impl.deletionProtection())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val copyTagsToSnapshot: scala.Option[BooleanOptional] = scala
      .Option(impl.copyTagsToSnapshot())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val domain: scala.Option[String] =
      scala.Option(impl.domain()).map(value => value: String)
    override val domainIAMRoleName: scala.Option[String] =
      scala.Option(impl.domainIAMRoleName()).map(value => value: String)
    override val scalingConfiguration
        : scala.Option[zio.aws.rds.model.ScalingConfiguration.ReadOnly] = scala
      .Option(impl.scalingConfiguration())
      .map(value => zio.aws.rds.model.ScalingConfiguration.wrap(value))
    override val engineMode: scala.Option[String] =
      scala.Option(impl.engineMode()).map(value => value: String)
    override val dbClusterInstanceClass: scala.Option[String] =
      scala.Option(impl.dbClusterInstanceClass()).map(value => value: String)
    override val storageType: scala.Option[String] =
      scala.Option(impl.storageType()).map(value => value: String)
    override val publiclyAccessible: scala.Option[BooleanOptional] = scala
      .Option(impl.publiclyAccessible())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val iops: scala.Option[IntegerOptional] = scala
      .Option(impl.iops())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeRequest
  ): zio.aws.rds.model.RestoreDbClusterToPointInTimeRequest.ReadOnly =
    new Wrapper(impl)
}
