package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PendingCloudwatchLogsExports(
    logTypesToEnable: scala.Option[Iterable[String]] = None,
    logTypesToDisable: scala.Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.PendingCloudwatchLogsExports = {
    import PendingCloudwatchLogsExports.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.PendingCloudwatchLogsExports
      .builder()
      .optionallyWith(
        logTypesToEnable.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.logTypesToEnable)
      .optionallyWith(
        logTypesToDisable.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.logTypesToDisable)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.PendingCloudwatchLogsExports.ReadOnly =
    zio.aws.rds.model.PendingCloudwatchLogsExports.wrap(buildAwsValue())
}
object PendingCloudwatchLogsExports {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.PendingCloudwatchLogsExports
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.PendingCloudwatchLogsExports =
      zio.aws.rds.model.PendingCloudwatchLogsExports(
        logTypesToEnable.map(value => value),
        logTypesToDisable.map(value => value)
      )
    def logTypesToEnable: scala.Option[List[String]]
    def logTypesToDisable: scala.Option[List[String]]
    def getLogTypesToEnable: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("logTypesToEnable", logTypesToEnable)
    def getLogTypesToDisable: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("logTypesToDisable", logTypesToDisable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.PendingCloudwatchLogsExports
  ) extends zio.aws.rds.model.PendingCloudwatchLogsExports.ReadOnly {
    override val logTypesToEnable: scala.Option[List[String]] = scala
      .Option(impl.logTypesToEnable())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val logTypesToDisable: scala.Option[List[String]] = scala
      .Option(impl.logTypesToDisable())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.PendingCloudwatchLogsExports
  ): zio.aws.rds.model.PendingCloudwatchLogsExports.ReadOnly = new Wrapper(impl)
}
