package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.{BooleanOptional, IntegerOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OptionGroupOption(
    name: scala.Option[String] = None,
    description: scala.Option[String] = None,
    engineName: scala.Option[String] = None,
    majorEngineVersion: scala.Option[String] = None,
    minimumRequiredMinorEngineVersion: scala.Option[String] = None,
    portRequired: scala.Option[Boolean] = None,
    defaultPort: scala.Option[IntegerOptional] = None,
    optionsDependedOn: scala.Option[Iterable[String]] = None,
    optionsConflictsWith: scala.Option[Iterable[String]] = None,
    persistent: scala.Option[Boolean] = None,
    permanent: scala.Option[Boolean] = None,
    requiresAutoMinorEngineVersionUpgrade: scala.Option[Boolean] = None,
    vpcOnly: scala.Option[Boolean] = None,
    supportsOptionVersionDowngrade: scala.Option[BooleanOptional] = None,
    optionGroupOptionSettings: scala.Option[Iterable[
      zio.aws.rds.model.OptionGroupOptionSetting
    ]] = None,
    optionGroupOptionVersions: scala.Option[Iterable[
      zio.aws.rds.model.OptionVersion
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.OptionGroupOption = {
    import OptionGroupOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.OptionGroupOption
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(engineName.map(value => value: java.lang.String))(
        _.engineName
      )
      .optionallyWith(majorEngineVersion.map(value => value: java.lang.String))(
        _.majorEngineVersion
      )
      .optionallyWith(
        minimumRequiredMinorEngineVersion.map(value => value: java.lang.String)
      )(_.minimumRequiredMinorEngineVersion)
      .optionallyWith(portRequired.map(value => value: java.lang.Boolean))(
        _.portRequired
      )
      .optionallyWith(
        defaultPort.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.defaultPort)
      .optionallyWith(
        optionsDependedOn.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.optionsDependedOn)
      .optionallyWith(
        optionsConflictsWith.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.optionsConflictsWith)
      .optionallyWith(persistent.map(value => value: java.lang.Boolean))(
        _.persistent
      )
      .optionallyWith(permanent.map(value => value: java.lang.Boolean))(
        _.permanent
      )
      .optionallyWith(
        requiresAutoMinorEngineVersionUpgrade.map(value =>
          value: java.lang.Boolean
        )
      )(_.requiresAutoMinorEngineVersionUpgrade)
      .optionallyWith(vpcOnly.map(value => value: java.lang.Boolean))(_.vpcOnly)
      .optionallyWith(
        supportsOptionVersionDowngrade.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.supportsOptionVersionDowngrade)
      .optionallyWith(
        optionGroupOptionSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionGroupOptionSettings)
      .optionallyWith(
        optionGroupOptionVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionGroupOptionVersions)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.OptionGroupOption.ReadOnly =
    zio.aws.rds.model.OptionGroupOption.wrap(buildAwsValue())
}
object OptionGroupOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.OptionGroupOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.OptionGroupOption =
      zio.aws.rds.model.OptionGroupOption(
        name.map(value => value),
        description.map(value => value),
        engineName.map(value => value),
        majorEngineVersion.map(value => value),
        minimumRequiredMinorEngineVersion.map(value => value),
        portRequired.map(value => value),
        defaultPort.map(value => value),
        optionsDependedOn.map(value => value),
        optionsConflictsWith.map(value => value),
        persistent.map(value => value),
        permanent.map(value => value),
        requiresAutoMinorEngineVersionUpgrade.map(value => value),
        vpcOnly.map(value => value),
        supportsOptionVersionDowngrade.map(value => value),
        optionGroupOptionSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        optionGroupOptionVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: scala.Option[String]
    def description: scala.Option[String]
    def engineName: scala.Option[String]
    def majorEngineVersion: scala.Option[String]
    def minimumRequiredMinorEngineVersion: scala.Option[String]
    def portRequired: scala.Option[Boolean]
    def defaultPort: scala.Option[IntegerOptional]
    def optionsDependedOn: scala.Option[List[String]]
    def optionsConflictsWith: scala.Option[List[String]]
    def persistent: scala.Option[Boolean]
    def permanent: scala.Option[Boolean]
    def requiresAutoMinorEngineVersionUpgrade: scala.Option[Boolean]
    def vpcOnly: scala.Option[Boolean]
    def supportsOptionVersionDowngrade: scala.Option[BooleanOptional]
    def optionGroupOptionSettings: scala.Option[List[
      zio.aws.rds.model.OptionGroupOptionSetting.ReadOnly
    ]]
    def optionGroupOptionVersions
        : scala.Option[List[zio.aws.rds.model.OptionVersion.ReadOnly]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEngineName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineName", engineName)
    def getMajorEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("majorEngineVersion", majorEngineVersion)
    def getMinimumRequiredMinorEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "minimumRequiredMinorEngineVersion",
        minimumRequiredMinorEngineVersion
      )
    def getPortRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("portRequired", portRequired)
    def getDefaultPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("defaultPort", defaultPort)
    def getOptionsDependedOn: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("optionsDependedOn", optionsDependedOn)
    def getOptionsConflictsWith: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("optionsConflictsWith", optionsConflictsWith)
    def getPersistent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("persistent", persistent)
    def getPermanent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("permanent", permanent)
    def getRequiresAutoMinorEngineVersionUpgrade: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "requiresAutoMinorEngineVersionUpgrade",
        requiresAutoMinorEngineVersionUpgrade
      )
    def getVpcOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("vpcOnly", vpcOnly)
    def getSupportsOptionVersionDowngrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "supportsOptionVersionDowngrade",
        supportsOptionVersionDowngrade
      )
    def getOptionGroupOptionSettings: ZIO[Any, AwsError, List[
      zio.aws.rds.model.OptionGroupOptionSetting.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "optionGroupOptionSettings",
      optionGroupOptionSettings
    )
    def getOptionGroupOptionVersions
        : ZIO[Any, AwsError, List[zio.aws.rds.model.OptionVersion.ReadOnly]] =
      AwsError.unwrapOptionField(
        "optionGroupOptionVersions",
        optionGroupOptionVersions
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.OptionGroupOption
  ) extends zio.aws.rds.model.OptionGroupOption.ReadOnly {
    override val name: scala.Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val description: scala.Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val engineName: scala.Option[String] =
      scala.Option(impl.engineName()).map(value => value: String)
    override val majorEngineVersion: scala.Option[String] =
      scala.Option(impl.majorEngineVersion()).map(value => value: String)
    override val minimumRequiredMinorEngineVersion: scala.Option[String] = scala
      .Option(impl.minimumRequiredMinorEngineVersion())
      .map(value => value: String)
    override val portRequired: scala.Option[Boolean] =
      scala.Option(impl.portRequired()).map(value => value: Boolean)
    override val defaultPort: scala.Option[IntegerOptional] = scala
      .Option(impl.defaultPort())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val optionsDependedOn: scala.Option[List[String]] = scala
      .Option(impl.optionsDependedOn())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val optionsConflictsWith: scala.Option[List[String]] = scala
      .Option(impl.optionsConflictsWith())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val persistent: scala.Option[Boolean] =
      scala.Option(impl.persistent()).map(value => value: Boolean)
    override val permanent: scala.Option[Boolean] =
      scala.Option(impl.permanent()).map(value => value: Boolean)
    override val requiresAutoMinorEngineVersionUpgrade: scala.Option[Boolean] =
      scala
        .Option(impl.requiresAutoMinorEngineVersionUpgrade())
        .map(value => value: Boolean)
    override val vpcOnly: scala.Option[Boolean] =
      scala.Option(impl.vpcOnly()).map(value => value: Boolean)
    override val supportsOptionVersionDowngrade: scala.Option[BooleanOptional] =
      scala
        .Option(impl.supportsOptionVersionDowngrade())
        .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val optionGroupOptionSettings: scala.Option[List[
      zio.aws.rds.model.OptionGroupOptionSetting.ReadOnly
    ]] = scala
      .Option(impl.optionGroupOptionSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.OptionGroupOptionSetting.wrap(item)
        }.toList
      )
    override val optionGroupOptionVersions
        : scala.Option[List[zio.aws.rds.model.OptionVersion.ReadOnly]] = scala
      .Option(impl.optionGroupOptionVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.OptionVersion.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.OptionGroupOption
  ): zio.aws.rds.model.OptionGroupOption.ReadOnly = new Wrapper(impl)
}
