package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyGlobalClusterRequest(
    globalClusterIdentifier: scala.Option[String] = None,
    newGlobalClusterIdentifier: scala.Option[String] = None,
    deletionProtection: scala.Option[BooleanOptional] = None,
    engineVersion: scala.Option[String] = None,
    allowMajorVersionUpgrade: scala.Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyGlobalClusterRequest = {
    import ModifyGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyGlobalClusterRequest
      .builder()
      .optionallyWith(
        globalClusterIdentifier.map(value => value: java.lang.String)
      )(_.globalClusterIdentifier)
      .optionallyWith(
        newGlobalClusterIdentifier.map(value => value: java.lang.String)
      )(_.newGlobalClusterIdentifier)
      .optionallyWith(
        deletionProtection.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.deletionProtection)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        allowMajorVersionUpgrade.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.allowMajorVersionUpgrade)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyGlobalClusterRequest.ReadOnly =
    zio.aws.rds.model.ModifyGlobalClusterRequest.wrap(buildAwsValue())
}
object ModifyGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyGlobalClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyGlobalClusterRequest =
      zio.aws.rds.model.ModifyGlobalClusterRequest(
        globalClusterIdentifier.map(value => value),
        newGlobalClusterIdentifier.map(value => value),
        deletionProtection.map(value => value),
        engineVersion.map(value => value),
        allowMajorVersionUpgrade.map(value => value)
      )
    def globalClusterIdentifier: scala.Option[String]
    def newGlobalClusterIdentifier: scala.Option[String]
    def deletionProtection: scala.Option[BooleanOptional]
    def engineVersion: scala.Option[String]
    def allowMajorVersionUpgrade: scala.Option[BooleanOptional]
    def getGlobalClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("globalClusterIdentifier", globalClusterIdentifier)
    def getNewGlobalClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "newGlobalClusterIdentifier",
        newGlobalClusterIdentifier
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAllowMajorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "allowMajorVersionUpgrade",
        allowMajorVersionUpgrade
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyGlobalClusterRequest
  ) extends zio.aws.rds.model.ModifyGlobalClusterRequest.ReadOnly {
    override val globalClusterIdentifier: scala.Option[String] =
      scala.Option(impl.globalClusterIdentifier()).map(value => value: String)
    override val newGlobalClusterIdentifier: scala.Option[String] = scala
      .Option(impl.newGlobalClusterIdentifier())
      .map(value => value: String)
    override val deletionProtection: scala.Option[BooleanOptional] = scala
      .Option(impl.deletionProtection())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val engineVersion: scala.Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val allowMajorVersionUpgrade: scala.Option[BooleanOptional] = scala
      .Option(impl.allowMajorVersionUpgrade())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyGlobalClusterRequest
  ): zio.aws.rds.model.ModifyGlobalClusterRequest.ReadOnly = new Wrapper(impl)
}
