package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyDbProxyResponse(
    dbProxy: scala.Option[zio.aws.rds.model.DBProxy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbProxyResponse = {
    import ModifyDbProxyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbProxyResponse
      .builder()
      .optionallyWith(dbProxy.map(value => value.buildAwsValue()))(_.dbProxy)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyDbProxyResponse.ReadOnly =
    zio.aws.rds.model.ModifyDbProxyResponse.wrap(buildAwsValue())
}
object ModifyDbProxyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbProxyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbProxyResponse = zio.aws.rds.model
      .ModifyDbProxyResponse(dbProxy.map(value => value.asEditable))
    def dbProxy: scala.Option[zio.aws.rds.model.DBProxy.ReadOnly]
    def getDbProxy: ZIO[Any, AwsError, zio.aws.rds.model.DBProxy.ReadOnly] =
      AwsError.unwrapOptionField("dbProxy", dbProxy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyResponse
  ) extends zio.aws.rds.model.ModifyDbProxyResponse.ReadOnly {
    override val dbProxy: scala.Option[zio.aws.rds.model.DBProxy.ReadOnly] =
      scala
        .Option(impl.dbProxy())
        .map(value => zio.aws.rds.model.DBProxy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyResponse
  ): zio.aws.rds.model.ModifyDbProxyResponse.ReadOnly = new Wrapper(impl)
}
