package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyDbClusterParameterGroupResponse(
    dbClusterParameterGroupName: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupResponse = {
    import ModifyDbClusterParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupResponse
      .builder()
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.ModifyDbClusterParameterGroupResponse.ReadOnly =
    zio.aws.rds.model.ModifyDbClusterParameterGroupResponse
      .wrap(buildAwsValue())
}
object ModifyDbClusterParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbClusterParameterGroupResponse =
      zio.aws.rds.model.ModifyDbClusterParameterGroupResponse(
        dbClusterParameterGroupName.map(value => value)
      )
    def dbClusterParameterGroupName: scala.Option[String]
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupResponse
  ) extends zio.aws.rds.model.ModifyDbClusterParameterGroupResponse.ReadOnly {
    override val dbClusterParameterGroupName: scala.Option[String] = scala
      .Option(impl.dbClusterParameterGroupName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupResponse
  ): zio.aws.rds.model.ModifyDbClusterParameterGroupResponse.ReadOnly =
    new Wrapper(impl)
}
