package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ImportInstallationMediaResponse(
    installationMediaId: scala.Option[String] = None,
    customAvailabilityZoneId: scala.Option[String] = None,
    engine: scala.Option[String] = None,
    engineVersion: scala.Option[String] = None,
    engineInstallationMediaPath: scala.Option[String] = None,
    osInstallationMediaPath: scala.Option[String] = None,
    status: scala.Option[String] = None,
    failureCause: scala.Option[
      zio.aws.rds.model.InstallationMediaFailureCause
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ImportInstallationMediaResponse = {
    import ImportInstallationMediaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ImportInstallationMediaResponse
      .builder()
      .optionallyWith(
        installationMediaId.map(value => value: java.lang.String)
      )(_.installationMediaId)
      .optionallyWith(
        customAvailabilityZoneId.map(value => value: java.lang.String)
      )(_.customAvailabilityZoneId)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        engineInstallationMediaPath.map(value => value: java.lang.String)
      )(_.engineInstallationMediaPath)
      .optionallyWith(
        osInstallationMediaPath.map(value => value: java.lang.String)
      )(_.osInstallationMediaPath)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(failureCause.map(value => value.buildAwsValue()))(
        _.failureCause
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ImportInstallationMediaResponse.ReadOnly =
    zio.aws.rds.model.ImportInstallationMediaResponse.wrap(buildAwsValue())
}
object ImportInstallationMediaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ImportInstallationMediaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ImportInstallationMediaResponse =
      zio.aws.rds.model.ImportInstallationMediaResponse(
        installationMediaId.map(value => value),
        customAvailabilityZoneId.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        engineInstallationMediaPath.map(value => value),
        osInstallationMediaPath.map(value => value),
        status.map(value => value),
        failureCause.map(value => value.asEditable)
      )
    def installationMediaId: scala.Option[String]
    def customAvailabilityZoneId: scala.Option[String]
    def engine: scala.Option[String]
    def engineVersion: scala.Option[String]
    def engineInstallationMediaPath: scala.Option[String]
    def osInstallationMediaPath: scala.Option[String]
    def status: scala.Option[String]
    def failureCause
        : scala.Option[zio.aws.rds.model.InstallationMediaFailureCause.ReadOnly]
    def getInstallationMediaId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("installationMediaId", installationMediaId)
    def getCustomAvailabilityZoneId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("customAvailabilityZoneId", customAvailabilityZoneId)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getEngineInstallationMediaPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "engineInstallationMediaPath",
        engineInstallationMediaPath
      )
    def getOsInstallationMediaPath: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("osInstallationMediaPath", osInstallationMediaPath)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getFailureCause: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.InstallationMediaFailureCause.ReadOnly
    ] = AwsError.unwrapOptionField("failureCause", failureCause)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ImportInstallationMediaResponse
  ) extends zio.aws.rds.model.ImportInstallationMediaResponse.ReadOnly {
    override val installationMediaId: scala.Option[String] =
      scala.Option(impl.installationMediaId()).map(value => value: String)
    override val customAvailabilityZoneId: scala.Option[String] =
      scala.Option(impl.customAvailabilityZoneId()).map(value => value: String)
    override val engine: scala.Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: scala.Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val engineInstallationMediaPath: scala.Option[String] = scala
      .Option(impl.engineInstallationMediaPath())
      .map(value => value: String)
    override val osInstallationMediaPath: scala.Option[String] =
      scala.Option(impl.osInstallationMediaPath()).map(value => value: String)
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val failureCause: scala.Option[
      zio.aws.rds.model.InstallationMediaFailureCause.ReadOnly
    ] = scala
      .Option(impl.failureCause())
      .map(value => zio.aws.rds.model.InstallationMediaFailureCause.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ImportInstallationMediaResponse
  ): zio.aws.rds.model.ImportInstallationMediaResponse.ReadOnly = new Wrapper(
    impl
  )
}
