package zio.aws.rds.model
import zio.aws.rds.model.primitives.{Integer, TStamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ExportTask(
    exportTaskIdentifier: scala.Option[String] = None,
    sourceArn: scala.Option[String] = None,
    exportOnly: scala.Option[Iterable[String]] = None,
    snapshotTime: scala.Option[TStamp] = None,
    taskStartTime: scala.Option[TStamp] = None,
    taskEndTime: scala.Option[TStamp] = None,
    s3Bucket: scala.Option[String] = None,
    s3Prefix: scala.Option[String] = None,
    iamRoleArn: scala.Option[String] = None,
    kmsKeyId: scala.Option[String] = None,
    status: scala.Option[String] = None,
    percentProgress: scala.Option[Integer] = None,
    totalExtractedDataInGB: scala.Option[Integer] = None,
    failureCause: scala.Option[String] = None,
    warningMessage: scala.Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.ExportTask = {
    import ExportTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ExportTask
      .builder()
      .optionallyWith(
        exportTaskIdentifier.map(value => value: java.lang.String)
      )(_.exportTaskIdentifier)
      .optionallyWith(sourceArn.map(value => value: java.lang.String))(
        _.sourceArn
      )
      .optionallyWith(
        exportOnly.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.exportOnly)
      .optionallyWith(snapshotTime.map(value => TStamp.unwrap(value): Instant))(
        _.snapshotTime
      )
      .optionallyWith(
        taskStartTime.map(value => TStamp.unwrap(value): Instant)
      )(_.taskStartTime)
      .optionallyWith(taskEndTime.map(value => TStamp.unwrap(value): Instant))(
        _.taskEndTime
      )
      .optionallyWith(s3Bucket.map(value => value: java.lang.String))(
        _.s3Bucket
      )
      .optionallyWith(s3Prefix.map(value => value: java.lang.String))(
        _.s3Prefix
      )
      .optionallyWith(iamRoleArn.map(value => value: java.lang.String))(
        _.iamRoleArn
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        percentProgress.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.percentProgress)
      .optionallyWith(
        totalExtractedDataInGB.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.totalExtractedDataInGB)
      .optionallyWith(failureCause.map(value => value: java.lang.String))(
        _.failureCause
      )
      .optionallyWith(warningMessage.map(value => value: java.lang.String))(
        _.warningMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ExportTask.ReadOnly =
    zio.aws.rds.model.ExportTask.wrap(buildAwsValue())
}
object ExportTask {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.ExportTask] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ExportTask = zio.aws.rds.model.ExportTask(
      exportTaskIdentifier.map(value => value),
      sourceArn.map(value => value),
      exportOnly.map(value => value),
      snapshotTime.map(value => value),
      taskStartTime.map(value => value),
      taskEndTime.map(value => value),
      s3Bucket.map(value => value),
      s3Prefix.map(value => value),
      iamRoleArn.map(value => value),
      kmsKeyId.map(value => value),
      status.map(value => value),
      percentProgress.map(value => value),
      totalExtractedDataInGB.map(value => value),
      failureCause.map(value => value),
      warningMessage.map(value => value)
    )
    def exportTaskIdentifier: scala.Option[String]
    def sourceArn: scala.Option[String]
    def exportOnly: scala.Option[List[String]]
    def snapshotTime: scala.Option[TStamp]
    def taskStartTime: scala.Option[TStamp]
    def taskEndTime: scala.Option[TStamp]
    def s3Bucket: scala.Option[String]
    def s3Prefix: scala.Option[String]
    def iamRoleArn: scala.Option[String]
    def kmsKeyId: scala.Option[String]
    def status: scala.Option[String]
    def percentProgress: scala.Option[Integer]
    def totalExtractedDataInGB: scala.Option[Integer]
    def failureCause: scala.Option[String]
    def warningMessage: scala.Option[String]
    def getExportTaskIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("exportTaskIdentifier", exportTaskIdentifier)
    def getSourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getExportOnly: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("exportOnly", exportOnly)
    def getSnapshotTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("snapshotTime", snapshotTime)
    def getTaskStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("taskStartTime", taskStartTime)
    def getTaskEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("taskEndTime", taskEndTime)
    def getS3Bucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Prefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Prefix", s3Prefix)
    def getIamRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getPercentProgress: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("percentProgress", percentProgress)
    def getTotalExtractedDataInGB: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("totalExtractedDataInGB", totalExtractedDataInGB)
    def getFailureCause: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureCause", failureCause)
    def getWarningMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("warningMessage", warningMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ExportTask
  ) extends zio.aws.rds.model.ExportTask.ReadOnly {
    override val exportTaskIdentifier: scala.Option[String] =
      scala.Option(impl.exportTaskIdentifier()).map(value => value: String)
    override val sourceArn: scala.Option[String] =
      scala.Option(impl.sourceArn()).map(value => value: String)
    override val exportOnly: scala.Option[List[String]] = scala
      .Option(impl.exportOnly())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val snapshotTime: scala.Option[TStamp] = scala
      .Option(impl.snapshotTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val taskStartTime: scala.Option[TStamp] = scala
      .Option(impl.taskStartTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val taskEndTime: scala.Option[TStamp] = scala
      .Option(impl.taskEndTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val s3Bucket: scala.Option[String] =
      scala.Option(impl.s3Bucket()).map(value => value: String)
    override val s3Prefix: scala.Option[String] =
      scala.Option(impl.s3Prefix()).map(value => value: String)
    override val iamRoleArn: scala.Option[String] =
      scala.Option(impl.iamRoleArn()).map(value => value: String)
    override val kmsKeyId: scala.Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val percentProgress: scala.Option[Integer] = scala
      .Option(impl.percentProgress())
      .map(value => zio.aws.rds.model.primitives.Integer(value))
    override val totalExtractedDataInGB: scala.Option[Integer] = scala
      .Option(impl.totalExtractedDataInGB())
      .map(value => zio.aws.rds.model.primitives.Integer(value))
    override val failureCause: scala.Option[String] =
      scala.Option(impl.failureCause()).map(value => value: String)
    override val warningMessage: scala.Option[String] =
      scala.Option(impl.warningMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ExportTask
  ): zio.aws.rds.model.ExportTask.ReadOnly = new Wrapper(impl)
}
