package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSourceRegionsRequest(
    regionName: scala.Option[String] = None,
    maxRecords: scala.Option[IntegerOptional] = None,
    marker: scala.Option[String] = None,
    filters: scala.Option[Iterable[zio.aws.rds.model.Filter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest = {
    import DescribeSourceRegionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest
      .builder()
      .optionallyWith(regionName.map(value => value: java.lang.String))(
        _.regionName
      )
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeSourceRegionsRequest.ReadOnly =
    zio.aws.rds.model.DescribeSourceRegionsRequest.wrap(buildAwsValue())
}
object DescribeSourceRegionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeSourceRegionsRequest =
      zio.aws.rds.model.DescribeSourceRegionsRequest(
        regionName.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def regionName: scala.Option[String]
    def maxRecords: scala.Option[IntegerOptional]
    def marker: scala.Option[String]
    def filters: scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]]
    def getRegionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("regionName", regionName)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest
  ) extends zio.aws.rds.model.DescribeSourceRegionsRequest.ReadOnly {
    override val regionName: scala.Option[String] =
      scala.Option(impl.regionName()).map(value => value: String)
    override val maxRecords: scala.Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val filters
        : scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Filter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest
  ): zio.aws.rds.model.DescribeSourceRegionsRequest.ReadOnly = new Wrapper(impl)
}
