package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeReservedDbInstancesOfferingsResponse(
    marker: scala.Option[String] = None,
    reservedDBInstancesOfferings: scala.Option[Iterable[
      zio.aws.rds.model.ReservedDBInstancesOffering
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse = {
    import DescribeReservedDbInstancesOfferingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        reservedDBInstancesOfferings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedDBInstancesOfferings)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeReservedDbInstancesOfferingsResponse.ReadOnly =
    zio.aws.rds.model.DescribeReservedDbInstancesOfferingsResponse
      .wrap(buildAwsValue())
}
object DescribeReservedDbInstancesOfferingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rds.model.DescribeReservedDbInstancesOfferingsResponse =
      zio.aws.rds.model.DescribeReservedDbInstancesOfferingsResponse(
        marker.map(value => value),
        reservedDBInstancesOfferings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: scala.Option[String]
    def reservedDBInstancesOfferings: scala.Option[List[
      zio.aws.rds.model.ReservedDBInstancesOffering.ReadOnly
    ]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReservedDBInstancesOfferings: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ReservedDBInstancesOffering.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "reservedDBInstancesOfferings",
      reservedDBInstancesOfferings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse
  ) extends zio.aws.rds.model.DescribeReservedDbInstancesOfferingsResponse.ReadOnly {
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val reservedDBInstancesOfferings: scala.Option[List[
      zio.aws.rds.model.ReservedDBInstancesOffering.ReadOnly
    ]] = scala
      .Option(impl.reservedDBInstancesOfferings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.ReservedDBInstancesOffering.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse
  ): zio.aws.rds.model.DescribeReservedDbInstancesOfferingsResponse.ReadOnly =
    new Wrapper(impl)
}
