package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeOrderableDbInstanceOptionsResponse(
    orderableDBInstanceOptions: scala.Option[Iterable[
      zio.aws.rds.model.OrderableDBInstanceOption
    ]] = None,
    marker: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse = {
    import DescribeOrderableDbInstanceOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse
      .builder()
      .optionallyWith(
        orderableDBInstanceOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.orderableDBInstanceOptions)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly =
    zio.aws.rds.model.DescribeOrderableDbInstanceOptionsResponse
      .wrap(buildAwsValue())
}
object DescribeOrderableDbInstanceOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rds.model.DescribeOrderableDbInstanceOptionsResponse =
      zio.aws.rds.model.DescribeOrderableDbInstanceOptionsResponse(
        orderableDBInstanceOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def orderableDBInstanceOptions: scala.Option[List[
      zio.aws.rds.model.OrderableDBInstanceOption.ReadOnly
    ]]
    def marker: scala.Option[String]
    def getOrderableDBInstanceOptions: ZIO[Any, AwsError, List[
      zio.aws.rds.model.OrderableDBInstanceOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "orderableDBInstanceOptions",
      orderableDBInstanceOptions
    )
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse
  ) extends zio.aws.rds.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly {
    override val orderableDBInstanceOptions: scala.Option[List[
      zio.aws.rds.model.OrderableDBInstanceOption.ReadOnly
    ]] = scala
      .Option(impl.orderableDBInstanceOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.OrderableDBInstanceOption.wrap(item)
        }.toList
      )
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse
  ): zio.aws.rds.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly =
    new Wrapper(impl)
}
