package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeOptionGroupsResponse(
    optionGroupsList: scala.Option[Iterable[zio.aws.rds.model.OptionGroup]] =
      None,
    marker: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse = {
    import DescribeOptionGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse
      .builder()
      .optionallyWith(
        optionGroupsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionGroupsList)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeOptionGroupsResponse.ReadOnly =
    zio.aws.rds.model.DescribeOptionGroupsResponse.wrap(buildAwsValue())
}
object DescribeOptionGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeOptionGroupsResponse =
      zio.aws.rds.model.DescribeOptionGroupsResponse(
        optionGroupsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def optionGroupsList
        : scala.Option[List[zio.aws.rds.model.OptionGroup.ReadOnly]]
    def marker: scala.Option[String]
    def getOptionGroupsList
        : ZIO[Any, AwsError, List[zio.aws.rds.model.OptionGroup.ReadOnly]] =
      AwsError.unwrapOptionField("optionGroupsList", optionGroupsList)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse
  ) extends zio.aws.rds.model.DescribeOptionGroupsResponse.ReadOnly {
    override val optionGroupsList
        : scala.Option[List[zio.aws.rds.model.OptionGroup.ReadOnly]] = scala
      .Option(impl.optionGroupsList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.OptionGroup.wrap(item)
        }.toList
      )
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse
  ): zio.aws.rds.model.DescribeOptionGroupsResponse.ReadOnly = new Wrapper(impl)
}
