package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.MaxRecords
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeExportTasksRequest(
    exportTaskIdentifier: scala.Option[String] = None,
    sourceArn: scala.Option[String] = None,
    filters: scala.Option[Iterable[zio.aws.rds.model.Filter]] = None,
    marker: scala.Option[String] = None,
    maxRecords: scala.Option[MaxRecords] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest = {
    import DescribeExportTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest
      .builder()
      .optionallyWith(
        exportTaskIdentifier.map(value => value: java.lang.String)
      )(_.exportTaskIdentifier)
      .optionallyWith(sourceArn.map(value => value: java.lang.String))(
        _.sourceArn
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxRecords.map(value => MaxRecords.unwrap(value): Integer)
      )(_.maxRecords)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeExportTasksRequest.ReadOnly =
    zio.aws.rds.model.DescribeExportTasksRequest.wrap(buildAwsValue())
}
object DescribeExportTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeExportTasksRequest =
      zio.aws.rds.model.DescribeExportTasksRequest(
        exportTaskIdentifier.map(value => value),
        sourceArn.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value),
        maxRecords.map(value => value)
      )
    def exportTaskIdentifier: scala.Option[String]
    def sourceArn: scala.Option[String]
    def filters: scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]]
    def marker: scala.Option[String]
    def maxRecords: scala.Option[MaxRecords]
    def getExportTaskIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("exportTaskIdentifier", exportTaskIdentifier)
    def getSourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxRecords: ZIO[Any, AwsError, MaxRecords] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest
  ) extends zio.aws.rds.model.DescribeExportTasksRequest.ReadOnly {
    override val exportTaskIdentifier: scala.Option[String] =
      scala.Option(impl.exportTaskIdentifier()).map(value => value: String)
    override val sourceArn: scala.Option[String] =
      scala.Option(impl.sourceArn()).map(value => value: String)
    override val filters
        : scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Filter.wrap(item)
        }.toList
      )
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxRecords: scala.Option[MaxRecords] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.rds.model.primitives.MaxRecords(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest
  ): zio.aws.rds.model.DescribeExportTasksRequest.ReadOnly = new Wrapper(impl)
}
