package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeEventSubscriptionsResponse(
    marker: scala.Option[String] = None,
    eventSubscriptionsList: scala.Option[Iterable[
      zio.aws.rds.model.EventSubscription
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse = {
    import DescribeEventSubscriptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        eventSubscriptionsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventSubscriptionsList)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeEventSubscriptionsResponse.ReadOnly =
    zio.aws.rds.model.DescribeEventSubscriptionsResponse.wrap(buildAwsValue())
}
object DescribeEventSubscriptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeEventSubscriptionsResponse =
      zio.aws.rds.model.DescribeEventSubscriptionsResponse(
        marker.map(value => value),
        eventSubscriptionsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: scala.Option[String]
    def eventSubscriptionsList
        : scala.Option[List[zio.aws.rds.model.EventSubscription.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getEventSubscriptionsList: ZIO[Any, AwsError, List[
      zio.aws.rds.model.EventSubscription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "eventSubscriptionsList",
      eventSubscriptionsList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse
  ) extends zio.aws.rds.model.DescribeEventSubscriptionsResponse.ReadOnly {
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val eventSubscriptionsList
        : scala.Option[List[zio.aws.rds.model.EventSubscription.ReadOnly]] =
      scala
        .Option(impl.eventSubscriptionsList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.EventSubscription.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse
  ): zio.aws.rds.model.DescribeEventSubscriptionsResponse.ReadOnly =
    new Wrapper(impl)
}
