package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDbProxiesResponse(
    dbProxies: scala.Option[Iterable[zio.aws.rds.model.DBProxy]] = None,
    marker: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse = {
    import DescribeDbProxiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse
      .builder()
      .optionallyWith(
        dbProxies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbProxies)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbProxiesResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbProxiesResponse.wrap(buildAwsValue())
}
object DescribeDbProxiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbProxiesResponse =
      zio.aws.rds.model.DescribeDbProxiesResponse(
        dbProxies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def dbProxies: scala.Option[List[zio.aws.rds.model.DBProxy.ReadOnly]]
    def marker: scala.Option[String]
    def getDbProxies
        : ZIO[Any, AwsError, List[zio.aws.rds.model.DBProxy.ReadOnly]] =
      AwsError.unwrapOptionField("dbProxies", dbProxies)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse
  ) extends zio.aws.rds.model.DescribeDbProxiesResponse.ReadOnly {
    override val dbProxies
        : scala.Option[List[zio.aws.rds.model.DBProxy.ReadOnly]] = scala
      .Option(impl.dbProxies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBProxy.wrap(item)
        }.toList
      )
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse
  ): zio.aws.rds.model.DescribeDbProxiesResponse.ReadOnly = new Wrapper(impl)
}
