package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDbLogFilesResponse(
    describeDBLogFiles: scala.Option[Iterable[
      zio.aws.rds.model.DescribeDBLogFilesDetails
    ]] = None,
    marker: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse = {
    import DescribeDbLogFilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse
      .builder()
      .optionallyWith(
        describeDBLogFiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.describeDBLogFiles)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbLogFilesResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbLogFilesResponse.wrap(buildAwsValue())
}
object DescribeDbLogFilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbLogFilesResponse =
      zio.aws.rds.model.DescribeDbLogFilesResponse(
        describeDBLogFiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def describeDBLogFiles: scala.Option[List[
      zio.aws.rds.model.DescribeDBLogFilesDetails.ReadOnly
    ]]
    def marker: scala.Option[String]
    def getDescribeDBLogFiles: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DescribeDBLogFilesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("describeDBLogFiles", describeDBLogFiles)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse
  ) extends zio.aws.rds.model.DescribeDbLogFilesResponse.ReadOnly {
    override val describeDBLogFiles: scala.Option[List[
      zio.aws.rds.model.DescribeDBLogFilesDetails.ReadOnly
    ]] = scala
      .Option(impl.describeDBLogFiles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DescribeDBLogFilesDetails.wrap(item)
        }.toList
      )
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse
  ): zio.aws.rds.model.DescribeDbLogFilesResponse.ReadOnly = new Wrapper(impl)
}
