package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeCustomAvailabilityZonesResponse(
    marker: scala.Option[String] = None,
    customAvailabilityZones: scala.Option[Iterable[
      zio.aws.rds.model.CustomAvailabilityZone
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesResponse = {
    import DescribeCustomAvailabilityZonesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        customAvailabilityZones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customAvailabilityZones)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeCustomAvailabilityZonesResponse.ReadOnly =
    zio.aws.rds.model.DescribeCustomAvailabilityZonesResponse
      .wrap(buildAwsValue())
}
object DescribeCustomAvailabilityZonesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeCustomAvailabilityZonesResponse =
      zio.aws.rds.model.DescribeCustomAvailabilityZonesResponse(
        marker.map(value => value),
        customAvailabilityZones.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: scala.Option[String]
    def customAvailabilityZones
        : scala.Option[List[zio.aws.rds.model.CustomAvailabilityZone.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getCustomAvailabilityZones: ZIO[Any, AwsError, List[
      zio.aws.rds.model.CustomAvailabilityZone.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "customAvailabilityZones",
      customAvailabilityZones
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesResponse
  ) extends zio.aws.rds.model.DescribeCustomAvailabilityZonesResponse.ReadOnly {
    override val marker: scala.Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val customAvailabilityZones: scala.Option[List[
      zio.aws.rds.model.CustomAvailabilityZone.ReadOnly
    ]] = scala
      .Option(impl.customAvailabilityZones())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.CustomAvailabilityZone.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesResponse
  ): zio.aws.rds.model.DescribeCustomAvailabilityZonesResponse.ReadOnly =
    new Wrapper(impl)
}
