package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DBInstanceRole(
    roleArn: scala.Option[String] = None,
    featureName: scala.Option[String] = None,
    status: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBInstanceRole = {
    import DBInstanceRole.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBInstanceRole
      .builder()
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(featureName.map(value => value: java.lang.String))(
        _.featureName
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBInstanceRole.ReadOnly =
    zio.aws.rds.model.DBInstanceRole.wrap(buildAwsValue())
}
object DBInstanceRole {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBInstanceRole
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBInstanceRole =
      zio.aws.rds.model.DBInstanceRole(
        roleArn.map(value => value),
        featureName.map(value => value),
        status.map(value => value)
      )
    def roleArn: scala.Option[String]
    def featureName: scala.Option[String]
    def status: scala.Option[String]
    def getRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getFeatureName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("featureName", featureName)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBInstanceRole
  ) extends zio.aws.rds.model.DBInstanceRole.ReadOnly {
    override val roleArn: scala.Option[String] =
      scala.Option(impl.roleArn()).map(value => value: String)
    override val featureName: scala.Option[String] =
      scala.Option(impl.featureName()).map(value => value: String)
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBInstanceRole
  ): zio.aws.rds.model.DBInstanceRole.ReadOnly = new Wrapper(impl)
}
