package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.{BooleanOptional, IntegerOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDbInstanceReadReplicaRequest(
    dbInstanceIdentifier: String,
    sourceDBInstanceIdentifier: String,
    dbInstanceClass: scala.Option[String] = None,
    availabilityZone: scala.Option[String] = None,
    port: scala.Option[IntegerOptional] = None,
    multiAZ: scala.Option[BooleanOptional] = None,
    autoMinorVersionUpgrade: scala.Option[BooleanOptional] = None,
    iops: scala.Option[IntegerOptional] = None,
    optionGroupName: scala.Option[String] = None,
    dbParameterGroupName: scala.Option[String] = None,
    publiclyAccessible: scala.Option[BooleanOptional] = None,
    tags: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None,
    dbSubnetGroupName: scala.Option[String] = None,
    vpcSecurityGroupIds: scala.Option[Iterable[String]] = None,
    storageType: scala.Option[String] = None,
    copyTagsToSnapshot: scala.Option[BooleanOptional] = None,
    monitoringInterval: scala.Option[IntegerOptional] = None,
    monitoringRoleArn: scala.Option[String] = None,
    kmsKeyId: scala.Option[String] = None,
    preSignedUrl: scala.Option[String] = None,
    enableIAMDatabaseAuthentication: scala.Option[BooleanOptional] = None,
    enablePerformanceInsights: scala.Option[BooleanOptional] = None,
    performanceInsightsKMSKeyId: scala.Option[String] = None,
    performanceInsightsRetentionPeriod: scala.Option[IntegerOptional] = None,
    enableCloudwatchLogsExports: scala.Option[Iterable[String]] = None,
    processorFeatures: scala.Option[Iterable[
      zio.aws.rds.model.ProcessorFeature
    ]] = None,
    useDefaultProcessorFeatures: scala.Option[BooleanOptional] = None,
    deletionProtection: scala.Option[BooleanOptional] = None,
    domain: scala.Option[String] = None,
    domainIAMRoleName: scala.Option[String] = None,
    replicaMode: scala.Option[zio.aws.rds.model.ReplicaMode] = None,
    maxAllocatedStorage: scala.Option[IntegerOptional] = None,
    customIamInstanceProfile: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest = {
    import CreateDbInstanceReadReplicaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .sourceDBInstanceIdentifier(sourceDBInstanceIdentifier: java.lang.String)
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(
        multiAZ.map(value => BooleanOptional.unwrap(value): java.lang.Boolean)
      )(_.multiAZ)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        iops.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.iops)
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        dbParameterGroupName.map(value => value: java.lang.String)
      )(_.dbParameterGroupName)
      .optionallyWith(
        publiclyAccessible.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.publiclyAccessible)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(
        copyTagsToSnapshot.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.copyTagsToSnapshot)
      .optionallyWith(
        monitoringInterval.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.monitoringInterval)
      .optionallyWith(monitoringRoleArn.map(value => value: java.lang.String))(
        _.monitoringRoleArn
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(preSignedUrl.map(value => value: java.lang.String))(
        _.preSignedUrl
      )
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.enableIAMDatabaseAuthentication)
      .optionallyWith(
        enablePerformanceInsights.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.enablePerformanceInsights)
      .optionallyWith(
        performanceInsightsKMSKeyId.map(value => value: java.lang.String)
      )(_.performanceInsightsKMSKeyId)
      .optionallyWith(
        performanceInsightsRetentionPeriod.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.performanceInsightsRetentionPeriod)
      .optionallyWith(
        enableCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableCloudwatchLogsExports)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .optionallyWith(
        useDefaultProcessorFeatures.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.useDefaultProcessorFeatures)
      .optionallyWith(
        deletionProtection.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.deletionProtection)
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(
        _.domainIAMRoleName
      )
      .optionallyWith(replicaMode.map(value => value.unwrap))(_.replicaMode)
      .optionallyWith(
        maxAllocatedStorage.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxAllocatedStorage)
      .optionallyWith(
        customIamInstanceProfile.map(value => value: java.lang.String)
      )(_.customIamInstanceProfile)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.CreateDbInstanceReadReplicaRequest.ReadOnly =
    zio.aws.rds.model.CreateDbInstanceReadReplicaRequest.wrap(buildAwsValue())
}
object CreateDbInstanceReadReplicaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbInstanceReadReplicaRequest =
      zio.aws.rds.model.CreateDbInstanceReadReplicaRequest(
        dbInstanceIdentifier,
        sourceDBInstanceIdentifier,
        dbInstanceClass.map(value => value),
        availabilityZone.map(value => value),
        port.map(value => value),
        multiAZ.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        iops.map(value => value),
        optionGroupName.map(value => value),
        dbParameterGroupName.map(value => value),
        publiclyAccessible.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbSubnetGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        storageType.map(value => value),
        copyTagsToSnapshot.map(value => value),
        monitoringInterval.map(value => value),
        monitoringRoleArn.map(value => value),
        kmsKeyId.map(value => value),
        preSignedUrl.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        enablePerformanceInsights.map(value => value),
        performanceInsightsKMSKeyId.map(value => value),
        performanceInsightsRetentionPeriod.map(value => value),
        enableCloudwatchLogsExports.map(value => value),
        processorFeatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        useDefaultProcessorFeatures.map(value => value),
        deletionProtection.map(value => value),
        domain.map(value => value),
        domainIAMRoleName.map(value => value),
        replicaMode.map(value => value),
        maxAllocatedStorage.map(value => value),
        customIamInstanceProfile.map(value => value)
      )
    def dbInstanceIdentifier: String
    def sourceDBInstanceIdentifier: String
    def dbInstanceClass: scala.Option[String]
    def availabilityZone: scala.Option[String]
    def port: scala.Option[IntegerOptional]
    def multiAZ: scala.Option[BooleanOptional]
    def autoMinorVersionUpgrade: scala.Option[BooleanOptional]
    def iops: scala.Option[IntegerOptional]
    def optionGroupName: scala.Option[String]
    def dbParameterGroupName: scala.Option[String]
    def publiclyAccessible: scala.Option[BooleanOptional]
    def tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def dbSubnetGroupName: scala.Option[String]
    def vpcSecurityGroupIds: scala.Option[List[String]]
    def storageType: scala.Option[String]
    def copyTagsToSnapshot: scala.Option[BooleanOptional]
    def monitoringInterval: scala.Option[IntegerOptional]
    def monitoringRoleArn: scala.Option[String]
    def kmsKeyId: scala.Option[String]
    def preSignedUrl: scala.Option[String]
    def enableIAMDatabaseAuthentication: scala.Option[BooleanOptional]
    def enablePerformanceInsights: scala.Option[BooleanOptional]
    def performanceInsightsKMSKeyId: scala.Option[String]
    def performanceInsightsRetentionPeriod: scala.Option[IntegerOptional]
    def enableCloudwatchLogsExports: scala.Option[List[String]]
    def processorFeatures
        : scala.Option[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]]
    def useDefaultProcessorFeatures: scala.Option[BooleanOptional]
    def deletionProtection: scala.Option[BooleanOptional]
    def domain: scala.Option[String]
    def domainIAMRoleName: scala.Option[String]
    def replicaMode: scala.Option[zio.aws.rds.model.ReplicaMode]
    def maxAllocatedStorage: scala.Option[IntegerOptional]
    def customIamInstanceProfile: scala.Option[String]
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getSourceDBInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceDBInstanceIdentifier)
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getDbParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupName)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getMonitoringInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("monitoringInterval", monitoringInterval)
    def getMonitoringRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArn)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPreSignedUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preSignedUrl", preSignedUrl)
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getEnablePerformanceInsights: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enablePerformanceInsights",
        enablePerformanceInsights
      )
    def getPerformanceInsightsKMSKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "performanceInsightsKMSKeyId",
        performanceInsightsKMSKeyId
      )
    def getPerformanceInsightsRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "performanceInsightsRetentionPeriod",
      performanceInsightsRetentionPeriod
    )
    def getEnableCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enableCloudwatchLogsExports",
        enableCloudwatchLogsExports
      )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
    def getUseDefaultProcessorFeatures: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "useDefaultProcessorFeatures",
        useDefaultProcessorFeatures
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getDomainIAMRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleName)
    def getReplicaMode: ZIO[Any, AwsError, zio.aws.rds.model.ReplicaMode] =
      AwsError.unwrapOptionField("replicaMode", replicaMode)
    def getMaxAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxAllocatedStorage", maxAllocatedStorage)
    def getCustomIamInstanceProfile: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("customIamInstanceProfile", customIamInstanceProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest
  ) extends zio.aws.rds.model.CreateDbInstanceReadReplicaRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val sourceDBInstanceIdentifier: String =
      impl.sourceDBInstanceIdentifier(): String
    override val dbInstanceClass: scala.Option[String] =
      scala.Option(impl.dbInstanceClass()).map(value => value: String)
    override val availabilityZone: scala.Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val port: scala.Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val multiAZ: scala.Option[BooleanOptional] = scala
      .Option(impl.multiAZ())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val autoMinorVersionUpgrade: scala.Option[BooleanOptional] = scala
      .Option(impl.autoMinorVersionUpgrade())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val iops: scala.Option[IntegerOptional] = scala
      .Option(impl.iops())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val optionGroupName: scala.Option[String] =
      scala.Option(impl.optionGroupName()).map(value => value: String)
    override val dbParameterGroupName: scala.Option[String] =
      scala.Option(impl.dbParameterGroupName()).map(value => value: String)
    override val publiclyAccessible: scala.Option[BooleanOptional] = scala
      .Option(impl.publiclyAccessible())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val dbSubnetGroupName: scala.Option[String] =
      scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
    override val vpcSecurityGroupIds: scala.Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val storageType: scala.Option[String] =
      scala.Option(impl.storageType()).map(value => value: String)
    override val copyTagsToSnapshot: scala.Option[BooleanOptional] = scala
      .Option(impl.copyTagsToSnapshot())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val monitoringInterval: scala.Option[IntegerOptional] = scala
      .Option(impl.monitoringInterval())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val monitoringRoleArn: scala.Option[String] =
      scala.Option(impl.monitoringRoleArn()).map(value => value: String)
    override val kmsKeyId: scala.Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val preSignedUrl: scala.Option[String] =
      scala.Option(impl.preSignedUrl()).map(value => value: String)
    override val enableIAMDatabaseAuthentication
        : scala.Option[BooleanOptional] = scala
      .Option(impl.enableIAMDatabaseAuthentication())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val enablePerformanceInsights: scala.Option[BooleanOptional] =
      scala
        .Option(impl.enablePerformanceInsights())
        .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val performanceInsightsKMSKeyId: scala.Option[String] = scala
      .Option(impl.performanceInsightsKMSKeyId())
      .map(value => value: String)
    override val performanceInsightsRetentionPeriod
        : scala.Option[IntegerOptional] = scala
      .Option(impl.performanceInsightsRetentionPeriod())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val enableCloudwatchLogsExports: scala.Option[List[String]] = scala
      .Option(impl.enableCloudwatchLogsExports())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val processorFeatures
        : scala.Option[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]] =
      scala
        .Option(impl.processorFeatures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.ProcessorFeature.wrap(item)
          }.toList
        )
    override val useDefaultProcessorFeatures: scala.Option[BooleanOptional] =
      scala
        .Option(impl.useDefaultProcessorFeatures())
        .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val deletionProtection: scala.Option[BooleanOptional] = scala
      .Option(impl.deletionProtection())
      .map(value => zio.aws.rds.model.primitives.BooleanOptional(value))
    override val domain: scala.Option[String] =
      scala.Option(impl.domain()).map(value => value: String)
    override val domainIAMRoleName: scala.Option[String] =
      scala.Option(impl.domainIAMRoleName()).map(value => value: String)
    override val replicaMode: scala.Option[zio.aws.rds.model.ReplicaMode] =
      scala
        .Option(impl.replicaMode())
        .map(value => zio.aws.rds.model.ReplicaMode.wrap(value))
    override val maxAllocatedStorage: scala.Option[IntegerOptional] = scala
      .Option(impl.maxAllocatedStorage())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val customIamInstanceProfile: scala.Option[String] =
      scala.Option(impl.customIamInstanceProfile()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest
  ): zio.aws.rds.model.CreateDbInstanceReadReplicaRequest.ReadOnly =
    new Wrapper(impl)
}
