package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CopyDbParameterGroupRequest(
    sourceDBParameterGroupIdentifier: String,
    targetDBParameterGroupIdentifier: String,
    targetDBParameterGroupDescription: String,
    tags: scala.Option[Iterable[zio.aws.rds.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CopyDbParameterGroupRequest = {
    import CopyDbParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CopyDbParameterGroupRequest
      .builder()
      .sourceDBParameterGroupIdentifier(
        sourceDBParameterGroupIdentifier: java.lang.String
      )
      .targetDBParameterGroupIdentifier(
        targetDBParameterGroupIdentifier: java.lang.String
      )
      .targetDBParameterGroupDescription(
        targetDBParameterGroupDescription: java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CopyDbParameterGroupRequest.ReadOnly =
    zio.aws.rds.model.CopyDbParameterGroupRequest.wrap(buildAwsValue())
}
object CopyDbParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CopyDbParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CopyDbParameterGroupRequest =
      zio.aws.rds.model.CopyDbParameterGroupRequest(
        sourceDBParameterGroupIdentifier,
        targetDBParameterGroupIdentifier,
        targetDBParameterGroupDescription,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceDBParameterGroupIdentifier: String
    def targetDBParameterGroupIdentifier: String
    def targetDBParameterGroupDescription: String
    def tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getSourceDBParameterGroupIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceDBParameterGroupIdentifier)
    def getTargetDBParameterGroupIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetDBParameterGroupIdentifier)
    def getTargetDBParameterGroupDescription: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetDBParameterGroupDescription)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CopyDbParameterGroupRequest
  ) extends zio.aws.rds.model.CopyDbParameterGroupRequest.ReadOnly {
    override val sourceDBParameterGroupIdentifier: String =
      impl.sourceDBParameterGroupIdentifier(): String
    override val targetDBParameterGroupIdentifier: String =
      impl.targetDBParameterGroupIdentifier(): String
    override val targetDBParameterGroupDescription: String =
      impl.targetDBParameterGroupDescription(): String
    override val tags: scala.Option[List[zio.aws.rds.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CopyDbParameterGroupRequest
  ): zio.aws.rds.model.CopyDbParameterGroupRequest.ReadOnly = new Wrapper(impl)
}
