package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StopActivityStreamResponse(
    kmsKeyId: scala.Option[String] = None,
    kinesisStreamName: scala.Option[String] = None,
    status: scala.Option[zio.aws.rds.model.ActivityStreamStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.StopActivityStreamResponse = {
    import StopActivityStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.StopActivityStreamResponse
      .builder()
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(kinesisStreamName.map(value => value: java.lang.String))(
        _.kinesisStreamName
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.StopActivityStreamResponse.ReadOnly =
    zio.aws.rds.model.StopActivityStreamResponse.wrap(buildAwsValue())
}
object StopActivityStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.StopActivityStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.StopActivityStreamResponse =
      zio.aws.rds.model.StopActivityStreamResponse(
        kmsKeyId.map(value => value),
        kinesisStreamName.map(value => value),
        status.map(value => value)
      )
    def kmsKeyId: scala.Option[String]
    def kinesisStreamName: scala.Option[String]
    def status: scala.Option[zio.aws.rds.model.ActivityStreamStatus]
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getKinesisStreamName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kinesisStreamName", kinesisStreamName)
    def getStatus: ZIO[Any, AwsError, zio.aws.rds.model.ActivityStreamStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.StopActivityStreamResponse
  ) extends zio.aws.rds.model.StopActivityStreamResponse.ReadOnly {
    override val kmsKeyId: scala.Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val kinesisStreamName: scala.Option[String] =
      scala.Option(impl.kinesisStreamName()).map(value => value: String)
    override val status: scala.Option[zio.aws.rds.model.ActivityStreamStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.rds.model.ActivityStreamStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.StopActivityStreamResponse
  ): zio.aws.rds.model.StopActivityStreamResponse.ReadOnly = new Wrapper(impl)
}
