package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OptionVersion(
    version: scala.Option[String] = None,
    isDefault: scala.Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.OptionVersion = {
    import OptionVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.OptionVersion
      .builder()
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.OptionVersion.ReadOnly =
    zio.aws.rds.model.OptionVersion.wrap(buildAwsValue())
}
object OptionVersion {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.OptionVersion] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.OptionVersion = zio.aws.rds.model
      .OptionVersion(version.map(value => value), isDefault.map(value => value))
    def version: scala.Option[String]
    def isDefault: scala.Option[Boolean]
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.OptionVersion
  ) extends zio.aws.rds.model.OptionVersion.ReadOnly {
    override val version: scala.Option[String] =
      scala.Option(impl.version()).map(value => value: String)
    override val isDefault: scala.Option[Boolean] =
      scala.Option(impl.isDefault()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.OptionVersion
  ): zio.aws.rds.model.OptionVersion.ReadOnly = new Wrapper(impl)
}
