package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OptionGroupMembership(
    optionGroupName: scala.Option[String] = None,
    status: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.OptionGroupMembership = {
    import OptionGroupMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.OptionGroupMembership
      .builder()
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.OptionGroupMembership.ReadOnly =
    zio.aws.rds.model.OptionGroupMembership.wrap(buildAwsValue())
}
object OptionGroupMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.OptionGroupMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.OptionGroupMembership =
      zio.aws.rds.model.OptionGroupMembership(
        optionGroupName.map(value => value),
        status.map(value => value)
      )
    def optionGroupName: scala.Option[String]
    def status: scala.Option[String]
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.OptionGroupMembership
  ) extends zio.aws.rds.model.OptionGroupMembership.ReadOnly {
    override val optionGroupName: scala.Option[String] =
      scala.Option(impl.optionGroupName()).map(value => value: String)
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.OptionGroupMembership
  ): zio.aws.rds.model.OptionGroupMembership.ReadOnly = new Wrapper(impl)
}
