package zio.aws.rds.model
import java.lang.Integer
import zio.aws.rds.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OptionConfiguration(
    optionName: String,
    port: scala.Option[IntegerOptional] = None,
    optionVersion: scala.Option[String] = None,
    dbSecurityGroupMemberships: scala.Option[Iterable[String]] = None,
    vpcSecurityGroupMemberships: scala.Option[Iterable[String]] = None,
    optionSettings: scala.Option[Iterable[zio.aws.rds.model.OptionSetting]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.OptionConfiguration = {
    import OptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.OptionConfiguration
      .builder()
      .optionName(optionName: java.lang.String)
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(optionVersion.map(value => value: java.lang.String))(
        _.optionVersion
      )
      .optionallyWith(
        dbSecurityGroupMemberships.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dbSecurityGroupMemberships)
      .optionallyWith(
        vpcSecurityGroupMemberships.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupMemberships)
      .optionallyWith(
        optionSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionSettings)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.OptionConfiguration.ReadOnly =
    zio.aws.rds.model.OptionConfiguration.wrap(buildAwsValue())
}
object OptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.OptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.OptionConfiguration =
      zio.aws.rds.model.OptionConfiguration(
        optionName,
        port.map(value => value),
        optionVersion.map(value => value),
        dbSecurityGroupMemberships.map(value => value),
        vpcSecurityGroupMemberships.map(value => value),
        optionSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def optionName: String
    def port: scala.Option[IntegerOptional]
    def optionVersion: scala.Option[String]
    def dbSecurityGroupMemberships: scala.Option[List[String]]
    def vpcSecurityGroupMemberships: scala.Option[List[String]]
    def optionSettings
        : scala.Option[List[zio.aws.rds.model.OptionSetting.ReadOnly]]
    def getOptionName: ZIO[Any, Nothing, String] = ZIO.succeed(optionName)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getOptionVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionVersion", optionVersion)
    def getDbSecurityGroupMemberships: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "dbSecurityGroupMemberships",
        dbSecurityGroupMemberships
      )
    def getVpcSecurityGroupMemberships: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "vpcSecurityGroupMemberships",
        vpcSecurityGroupMemberships
      )
    def getOptionSettings
        : ZIO[Any, AwsError, List[zio.aws.rds.model.OptionSetting.ReadOnly]] =
      AwsError.unwrapOptionField("optionSettings", optionSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.OptionConfiguration
  ) extends zio.aws.rds.model.OptionConfiguration.ReadOnly {
    override val optionName: String = impl.optionName(): String
    override val port: scala.Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value => zio.aws.rds.model.primitives.IntegerOptional(value))
    override val optionVersion: scala.Option[String] =
      scala.Option(impl.optionVersion()).map(value => value: String)
    override val dbSecurityGroupMemberships: scala.Option[List[String]] = scala
      .Option(impl.dbSecurityGroupMemberships())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val vpcSecurityGroupMemberships: scala.Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupMemberships())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val optionSettings
        : scala.Option[List[zio.aws.rds.model.OptionSetting.ReadOnly]] = scala
      .Option(impl.optionSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.OptionSetting.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.OptionConfiguration
  ): zio.aws.rds.model.OptionConfiguration.ReadOnly = new Wrapper(impl)
}
