package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ImportInstallationMediaRequest(
    customAvailabilityZoneId: String,
    engine: String,
    engineVersion: String,
    engineInstallationMediaPath: String,
    osInstallationMediaPath: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ImportInstallationMediaRequest = {
    import ImportInstallationMediaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ImportInstallationMediaRequest
      .builder()
      .customAvailabilityZoneId(customAvailabilityZoneId: java.lang.String)
      .engine(engine: java.lang.String)
      .engineVersion(engineVersion: java.lang.String)
      .engineInstallationMediaPath(
        engineInstallationMediaPath: java.lang.String
      )
      .osInstallationMediaPath(osInstallationMediaPath: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ImportInstallationMediaRequest.ReadOnly =
    zio.aws.rds.model.ImportInstallationMediaRequest.wrap(buildAwsValue())
}
object ImportInstallationMediaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ImportInstallationMediaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ImportInstallationMediaRequest =
      zio.aws.rds.model.ImportInstallationMediaRequest(
        customAvailabilityZoneId,
        engine,
        engineVersion,
        engineInstallationMediaPath,
        osInstallationMediaPath
      )
    def customAvailabilityZoneId: String
    def engine: String
    def engineVersion: String
    def engineInstallationMediaPath: String
    def osInstallationMediaPath: String
    def getCustomAvailabilityZoneId: ZIO[Any, Nothing, String] =
      ZIO.succeed(customAvailabilityZoneId)
    def getEngine: ZIO[Any, Nothing, String] = ZIO.succeed(engine)
    def getEngineVersion: ZIO[Any, Nothing, String] = ZIO.succeed(engineVersion)
    def getEngineInstallationMediaPath: ZIO[Any, Nothing, String] =
      ZIO.succeed(engineInstallationMediaPath)
    def getOsInstallationMediaPath: ZIO[Any, Nothing, String] =
      ZIO.succeed(osInstallationMediaPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ImportInstallationMediaRequest
  ) extends zio.aws.rds.model.ImportInstallationMediaRequest.ReadOnly {
    override val customAvailabilityZoneId: String =
      impl.customAvailabilityZoneId(): String
    override val engine: String = impl.engine(): String
    override val engineVersion: String = impl.engineVersion(): String
    override val engineInstallationMediaPath: String =
      impl.engineInstallationMediaPath(): String
    override val osInstallationMediaPath: String =
      impl.osInstallationMediaPath(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ImportInstallationMediaRequest
  ): zio.aws.rds.model.ImportInstallationMediaRequest.ReadOnly = new Wrapper(
    impl
  )
}
