package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class FailoverDbClusterRequest(
    dbClusterIdentifier: String,
    targetDBInstanceIdentifier: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.FailoverDbClusterRequest = {
    import FailoverDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.FailoverDbClusterRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(
        targetDBInstanceIdentifier.map(value => value: java.lang.String)
      )(_.targetDBInstanceIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.FailoverDbClusterRequest.ReadOnly =
    zio.aws.rds.model.FailoverDbClusterRequest.wrap(buildAwsValue())
}
object FailoverDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.FailoverDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.FailoverDbClusterRequest =
      zio.aws.rds.model.FailoverDbClusterRequest(
        dbClusterIdentifier,
        targetDBInstanceIdentifier.map(value => value)
      )
    def dbClusterIdentifier: String
    def targetDBInstanceIdentifier: scala.Option[String]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getTargetDBInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "targetDBInstanceIdentifier",
        targetDBInstanceIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.FailoverDbClusterRequest
  ) extends zio.aws.rds.model.FailoverDbClusterRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val targetDBInstanceIdentifier: scala.Option[String] = scala
      .Option(impl.targetDBInstanceIdentifier())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.FailoverDbClusterRequest
  ): zio.aws.rds.model.FailoverDbClusterRequest.ReadOnly = new Wrapper(impl)
}
