package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EventCategoriesMap(
    sourceType: scala.Option[String] = None,
    eventCategories: scala.Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.EventCategoriesMap = {
    import EventCategoriesMap.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.EventCategoriesMap
      .builder()
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .optionallyWith(
        eventCategories.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategories)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.EventCategoriesMap.ReadOnly =
    zio.aws.rds.model.EventCategoriesMap.wrap(buildAwsValue())
}
object EventCategoriesMap {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.EventCategoriesMap
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.EventCategoriesMap =
      zio.aws.rds.model.EventCategoriesMap(
        sourceType.map(value => value),
        eventCategories.map(value => value)
      )
    def sourceType: scala.Option[String]
    def eventCategories: scala.Option[List[String]]
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getEventCategories: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategories", eventCategories)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.EventCategoriesMap
  ) extends zio.aws.rds.model.EventCategoriesMap.ReadOnly {
    override val sourceType: scala.Option[String] =
      scala.Option(impl.sourceType()).map(value => value: String)
    override val eventCategories: scala.Option[List[String]] = scala
      .Option(impl.eventCategories())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.EventCategoriesMap
  ): zio.aws.rds.model.EventCategoriesMap.ReadOnly = new Wrapper(impl)
}
