package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EC2SecurityGroup(
    status: scala.Option[String] = None,
    ec2SecurityGroupName: scala.Option[String] = None,
    ec2SecurityGroupId: scala.Option[String] = None,
    ec2SecurityGroupOwnerId: scala.Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.EC2SecurityGroup = {
    import EC2SecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.EC2SecurityGroup
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        ec2SecurityGroupName.map(value => value: java.lang.String)
      )(_.ec2SecurityGroupName)
      .optionallyWith(ec2SecurityGroupId.map(value => value: java.lang.String))(
        _.ec2SecurityGroupId
      )
      .optionallyWith(
        ec2SecurityGroupOwnerId.map(value => value: java.lang.String)
      )(_.ec2SecurityGroupOwnerId)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.EC2SecurityGroup.ReadOnly =
    zio.aws.rds.model.EC2SecurityGroup.wrap(buildAwsValue())
}
object EC2SecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.EC2SecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.EC2SecurityGroup =
      zio.aws.rds.model.EC2SecurityGroup(
        status.map(value => value),
        ec2SecurityGroupName.map(value => value),
        ec2SecurityGroupId.map(value => value),
        ec2SecurityGroupOwnerId.map(value => value)
      )
    def status: scala.Option[String]
    def ec2SecurityGroupName: scala.Option[String]
    def ec2SecurityGroupId: scala.Option[String]
    def ec2SecurityGroupOwnerId: scala.Option[String]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getEc2SecurityGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2SecurityGroupName", ec2SecurityGroupName)
    def getEc2SecurityGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2SecurityGroupId", ec2SecurityGroupId)
    def getEc2SecurityGroupOwnerId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("ec2SecurityGroupOwnerId", ec2SecurityGroupOwnerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.EC2SecurityGroup
  ) extends zio.aws.rds.model.EC2SecurityGroup.ReadOnly {
    override val status: scala.Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val ec2SecurityGroupName: scala.Option[String] =
      scala.Option(impl.ec2SecurityGroupName()).map(value => value: String)
    override val ec2SecurityGroupId: scala.Option[String] =
      scala.Option(impl.ec2SecurityGroupId()).map(value => value: String)
    override val ec2SecurityGroupOwnerId: scala.Option[String] =
      scala.Option(impl.ec2SecurityGroupOwnerId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.EC2SecurityGroup
  ): zio.aws.rds.model.EC2SecurityGroup.ReadOnly = new Wrapper(impl)
}
