package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeEventCategoriesRequest(
    sourceType: scala.Option[String] = None,
    filters: scala.Option[Iterable[zio.aws.rds.model.Filter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeEventCategoriesRequest = {
    import DescribeEventCategoriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeEventCategoriesRequest
      .builder()
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeEventCategoriesRequest.ReadOnly =
    zio.aws.rds.model.DescribeEventCategoriesRequest.wrap(buildAwsValue())
}
object DescribeEventCategoriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeEventCategoriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeEventCategoriesRequest =
      zio.aws.rds.model.DescribeEventCategoriesRequest(
        sourceType.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceType: scala.Option[String]
    def filters: scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]]
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeEventCategoriesRequest
  ) extends zio.aws.rds.model.DescribeEventCategoriesRequest.ReadOnly {
    override val sourceType: scala.Option[String] =
      scala.Option(impl.sourceType()).map(value => value: String)
    override val filters
        : scala.Option[List[zio.aws.rds.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.Filter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeEventCategoriesRequest
  ): zio.aws.rds.model.DescribeEventCategoriesRequest.ReadOnly = new Wrapper(
    impl
  )
}
